nexus-grid Cookbook
===================

This cookbook sets up a Sonatype Nexus Repository Manager by Docker Compose.

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
    - [cookbooks](#cookbooks)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [nexus-grid::default](#nexus-griddefault)
        - [nexus-grid::docker-compose](#nexus-griddocker-compose)
    - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- RHEL, CentOS >= 7.0
- Debian >= 8.0
- Ubuntu >= 14.04

### packages
- none.

### cookbooks
- `docker-grid`
- `platform_utils`
- `ssl_cert`

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['nexus-grid']['docker-compose']['app_dir']`|String||`"#{node['docker-grid']['compose']['app_dir']}/nexus"`|
|`['nexus-grid']['docker-compose']['data_dir']`|String|Path string or nil (unset).|`"#{node['nexus-grid']['docker-compose']['app_dir']}/data"`|
|`['nexus-grid']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|

## Usage

### Recipes

#### nexus-grid::default

This recipe does nothing.

#### nexus-grid::docker-compose

This recipe generates a `docker-compose.yml` file for the Sonatype Nexus Repository Manager service.

### Role Examples

- `roles/nexus.rb`

```ruby
name 'nexus'
description 'Nexus'

run_list(
  'role[docker]',
  'recipe[nexus-grid::docker-compose]',
)

image = 'sonatype/nexus3'
port = '8081'

override_attributes(
  'nexus-grid' => {
    #'https_enabled' => true,  # not supported yet.
    'docker-compose' => {
      'config' => {
        'version' => '2',
        'services' => {
          'nexus' => {
            'restart' => 'always',
            'image' => image,
            'ports' => [
              "#{port}:8081",
            ],
            'volumes' => [
              # This volume will be set by the nexus-grid::docker-compose recipe automatically.
              #"#{node['nexus-grid']['docker-compose']['data_dir']}:/nexus-data",
            ],
            'environment' => {
              #JAVA_MAX_HEAP => '1200m',  # passed as -Xmx. Defaults to 1200m.
              #JAVA_MIN_HEAP => '1200m',  # passed as -Xms. Defaults to 1200m.
              #EXTRA_JAVA_OPTS => '',  # Additional options can be passed to the JVM via this variable.
            },
          },
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
