#
# Copyright 2013,2014 whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'
require 'rubygems'
require 'bracecomp'

name 'grid-gm'
description 'Grid Base ganglia gmetad node'

run_list(
  'role[node_commons]',
  'role[nameservice-client-grid]',
  'role[ganglia-gmond]',
  'role[ganglia-gmetad]',
  'role[ganglia-web]'
)

this_subcluster = Grid::CLUSTERS[:base][:gmetads]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
polling_interval = 30
=begin
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}
=end

data_sources = []
Grid::CLUSTERS[:base].each {|key, cluster|
  data_sources.push(
    {
      :name => cluster[:alias],
      :polling_interval => polling_interval,
      # head nodes: 2
      :address_list => cluster[:nodes].first(2).map{|host| "#{host}.#{Grid::DOMAIN}"}
    }
  )
}

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'ganglia' => {
    'web' => {
      'Allow' => [
        "from .#{Grid::DOMAIN}",
        'from 192.168.0.0/16'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => Grid::REALM,
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    }
  },
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => this_subcluster[:alias],
      'owner' => Grid::DOMAIN
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    },
    # gmetad
    'gridname' => 'Grid-Base',
    'trusted_hosts' => ['127.0.0.1'] \
      + Grid::CLUSTERS[:base][:nagioses][:nodes].map{|host| "#{host}.#{Grid::DOMAIN}"},
    'data_sources' => data_sources
  }
)
