name 'devops-suite-with-ssl-on-docker'
description 'DevOps Suite with SSL on Docker'

ca_name = 'grid_ca'
import_ca = false
host_cn = 'devops.io.example.com'
aptly_cn = host_cn       # 'aptly.io.example.com'
concourse_cn = host_cn   # 'concourse.io.example.com'
concourse_port    = '8443'
docker_reg_cn = host_cn  # 'registry.docker.example.com'
docker_reg_port   = '5000'
gitlab_cn = host_cn      # 'gitlab.io.example.com'  # default: node['fqdn']
gitlab_https_port =  '443'
nexus_cn = host_cn       # 'nexus.io.example.com'

common_names = [
  aptly_cn,
  concourse_cn,
  docker_reg_cn,
  gitlab_cn,
  nexus_cn,
].uniq

run_list(
  'role[devops-suite-on-docker]',
  'recipe[docker-grid::registry]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'ssl_cert' => {
    'ca_names' => [
      ca_name,
    ],
    'common_names' => common_names,
  },
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
    },
    'compose' => {
      'skip_setup' => false,
    },
    'registry' => {
      'with_ssl_cert_cookbook' => true,
      'ssl_cert' => {
        'common_name' => docker_reg_cn,
      },
      'docker-compose' => {
        'config' => {
          'registry' => {
            'ports' => [
              "#{docker_reg_port}:5000",
            ],
            'environment' => {
              #'REGISTRY_AUTH' =>                'htpasswd',
              #'REGISTRY_AUTH_HTPASSWD_PATH' =>  '/auth/.htpasswd',
              #'REGISTRY_AUTH_HTPASSWD_REALM' => 'Registry Realm',
              # proxy cache only.
              'REGISTRY_PROXY_REMOTEURL' => 'https://registry-1.docker.io',
            },
            'volumes' => [
              '/var/lib/docker-registry:/var/lib/registry',
              #'./auth:/auth',
            ],
          },
        },
      },
    },
  },
  'apt_utils' => {
    'aptly' => {
      'with_ssl_cert_cookbook' => true,
      'ssl_cert' => {
        'common_name' => aptly_cn,
      },
      'docker-compose' => {
        'config' => {
          'services' => {
            'reverseproxy' => {
              'ports' => [
              ],
              # 'network_mode' => 'bridge',
              # 'links' => [
              #   'aptly',
              # ],
            },
            'aptly' => {
              # 'network_mode' => 'bridge',
            },
          },
        },
      },
    },
  },
  'concourse-ci' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'ca_names' => [
        ca_name,
      ],
      'common_name' => concourse_cn,
    },
    'docker-compose' => {
      'import_ca' => import_ca,
      'config' => {
        # Version 1 docker-compose format
        'concourse-db' => {
        },
        'concourse-web' => {
          'ports' => [
            "#{concourse_port}:8443",
          ],
          'environment' => {
            'CONCOURSE_TLS_BIND_PORT' => '8443',
            'CONCOURSE_EXTERNAL_URL' => "https://#{concourse_cn}:#{concourse_port}",
          },
        },
        'concourse-worker' => {
          'environment' => {
          },
        },
      },
    },
  },
  'gitlab-grid' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'ca_name' => ca_name,
      'common_name' => gitlab_cn,
    },
    'gitlab.rb' => {
      'external_url' => "https://#{gitlab_cn}:#{gitlab_https_port}",
      'gitlab_rails' => {
        # 'time_zone' => 'Asia/Tokyo',
      },
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'gitlab' => {
            'hostname' => gitlab_cn,
            'ports' => [
              "#{gitlab_https_port}:#{gitlab_https_port}",
            ],
            # 'network_mode' => 'bridge',
          },
        },
      },
    },
    'runner-docker-compose' => {
      'import_ca' => import_ca,
    },
  },
  'nexus-grid' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => nexus_cn,
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'reverseproxy' => {
            'ports' => [
            ],
            # 'network_mode' => 'bridge',
            # 'links' => [
            #   'nexus',
            # ],
          },
          'nexus' => {
            # 'network_mode' => 'bridge',
          },
        },
      },
    },
  },
)
