name 'jenkins'
description 'Jenkins'

run_list(
  #'recipe[ssl_cert::server_key_pairs]',
  'role[docker]',
  'recipe[jenkins-grid::docker-compose]',
)

#env_run_lists()

#default_attributes()

jenkins_cn = 'jenkins.io.example.com'

override_attributes(
  'ssl_cert' => {
    'common_names' => [
      jenkins_cn,
    ],
  },
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
    },
    'compose' => {
      'skip_setup' => false,
    },
  },
  'jenkins-grid' => {
    #'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => jenkins_cn,
    },
    'docker-compose' => {
      'config' => {
        # Version 2 docker-compose format
        'version' => '2',
        'services' => {
          'jenkins' => {
            'restart' => 'always',
            'image' => 'jenkins:2.19.4',
            #'expose' => [
            #  '8083',  # for https
            #],
            'ports' => [
              '8080:8080',
              #'8083:8083',
              '50000:50000',
            ],
            'environment' => {
              'JENKINS_OPTS' => [
                #'--httpPort=-1 --httpsPort=8083',
                # These options will be set by the jenkins-grid::docker-compose recipe automatically.
                #'--httpsCertificate=/var/lib/jenkins/server.crt',
                #'--httpsPrivateKey=/var/lib/jenkins/server.key',
              ].join(' '),
            },
            # These volumes will be set by the jenkins-grid::docker-compose recipe automatically.
            #'volumes' => [
            #  "#{node['jenkins-grid']['docker-compose']['jenkins_home']['path']}:/var/jenkins_home",
            #  "#{server_cert_path(node['jenkins-grid']['ssl_cert']['common_name'])}:/var/lib/jenkins/server.crt:ro",
            #  "#{node['jenkins-grid']['docker-compose']['app_dir']}/certs/server.key:/var/lib/jenkins/server.key:ro",
            #],
          },
        },
      },
    },
  },
)
