samba-grid Cookbook
===================

This cookbook sets up a Samba server.

## Contents

- [Requirements](#requirements)
  - [platforms](#platforms)
  - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [samba-grid::default](#samba-griddefault)
    - [samba-grid::server](#samba-gridserver)
    - [samba-grid::smbldap-tools](#samba-gridsmbldap-tools)
  - [Role Examples](#role-examples)
  - [Password management by the Chef Vault](#password-management-by-the-chef-vault)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- Debian, Ubuntu

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['samba-grid']['group']['sambashare']['gid']`|String|`sambashare` group gid.|`nil`|
|`['samba-grid']['group']['sambashare']['members']`|Array|`sambashare` group members|`[]`|
|`['samba-grid']['smb.conf']`|Hash|Samba configurations.|See `attributes/default.rb`|
|`['samba-grid']['smb.conf']['global']`|Hash|`[global]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smb.conf']['homes']`|Hash|`[homes]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smb.conf']['printers']`|Hash|`[printers]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smb.conf']['printD']`|Hash|`[print$]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['SID']`|String|Required.|`''`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['sambaDomain']`|String||`'DOMSMB'`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['slaveLDAP']`|String||`'ldap://ldap.example.com/'`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['masterLDAP']`|String||`'ldap://ldap.example.com/'`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['ldapTLS']`|String||`'1'`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['suffix']`|String||`'dc=example,dc=com'`|
|`['samba-grid']['smbldap-tools']['smbldap.conf']['mailDomain']`|String||`'example.com'`|
|`['samba-grid']['smbldap-tools']['smbldap_bind.conf']['slaveDN']`|String||`'cn=Manager,dc=example,dc=com'`|
|`['samba-grid']['smbldap-tools']['smbldap_bind.conf']['slavePw_vault_item']`|String|See the following _Password management by the Chef Vault_|`{}`|
|`['samba-grid']['smbldap-tools']['smbldap_bind.conf']['masterDN']`|String||`'cn=Manager,dc=example,dc=com'`|
|`['samba-grid']['smbldap-tools']['smbldap_bind.conf']['masterPw_vault_item']`|String|See the following _Password management by the Chef Vault_|`{}`|

## Usage

### Recipes

#### samba-grid::default

This recipe does nothing.

#### samba-grid::server

This recipe installs Samba server.

#### samba-grid::smbldap-tools

This recipe installs the smbldap-tools.

### Role Examples

- `roles/samba.rb`

```ruby
name 'samba'
description 'Samba server'

run_list(
  'recipe[samba-grid::server]',
)

override_attributes(
  'samba-grid' => {
    'group' => {
      'sambashare' => {
        'gid' => '200',
        'members' => [
          'alice',
          'bob',
        ],
      },
    },
    'smb.conf' => {
      'global' => {
        'workgroup' => 'WORKGROUP',
        'wide links' => 'yes',
        'follow symlinks' => 'yes',
        'unix extensions' => 'no',
        'dos charset' => 'CP932',
        'printing' => 'BSD',
        'hosts allow' => '127. 192.168.1.',
        'passdb backend' => 'ldapsam:ldap://ldap.example.com',
        'ldap suffix' => 'dc=example,dc=com',
        'ldap user suffix' => 'ou=Users',
        'ldap group suffix' => 'ou=Groups',
        'ldap machine suffix' => 'ou=Computers',
        'ldap admin dn' => 'cn=admin,dc=example,dc=com',
        'ldap passwd sync' => 'yes',
        'ldap ssl' => 'start_tls',
        'usershare allow guests' => 'no',
      },
      'homes' => {
        'read only' => 'no',
        'create mask' => '0600',
        'vfs objects' => 'recycle',
        'recycle:keeptree' => 'yes',
      },
      'share' => {
        'comment' => 'shared data',
        'path' => '/u00/samba/share',
        'username' => 'alice, bob',
        'valid users' => 'alice, bob',
        'write list' => 'alice, bob',
        'force group' => 'sambashare',
        'read only' => 'No',
        'create mask' => '0660',
        'directory mask' => '0770',
        #'vfs objects' => 'recycle',
        #'recycle:keeptree' => 'yes',
      },
    },
  },
)
```

### Password management by the Chef Vault

- Generate a password JSON file.

```bash
$ ruby -rjson -e 'puts JSON.generate({"password" => File.read("masterPw.txt")})' \
> > ~/tmp/masterPw.txt.json
```

- Create a Chef Vault item.

```bash
$ knife vault create smbldap_bind_pws masterPw --json ~/tmp/masterPw.txt.json

$ knife vault show smbldap_bind_pws masterPw -F json
```

- Grant read permission to the server.

```bash
$ knife vault update smbldap_bind_pws masterPw -S 'name:ldap*.grid.example.com'
```

- Set attributes.

```ruby
override_attributes(
  'samba-grid' => {
    'smbldap-tools' => {
      'smbldap_bind.conf' => {
        'masterDN' => 'cn=Manager,dc=example,dc=com',
        'masterPw_vault_item' => {
          'vault' => 'smbldap_bind_pws',
          'name' => 'masterPw',
          'env_context' => false,
          'key' => 'password',
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
