name 'hadoop-pleiades-with-security'
description 'Pleiades Hadoop cluster node with security'

run_list(
  'role[node_commons]',
  'role[nameservice-client-grid]',
  'role[hadoop]',
  'role[jce_policy]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

grid_etc_root = '/grid/etc'
grid_vol_root = '/grid/vol'
cluster_name = 'pleiades'
hadoop_attributes = {
  'with_security' => true,
  # hadoop-env.sh
  'HADOOP_CLASSPATH' => '/usr/share/java/commons-daemon.jar',
  'HADOOP_USER_CLASSPATH_FIRST' => true,
  # core-site.xml
  'this.cluster.name' => cluster_name, 
  'this.domain' => 'grid.example.com',
  'this.realm' => 'GRID.EXAMPLE.COM',
  'this.keytab.dir' => "#{grid_etc_root}/keytabs/#{cluster_name}",
  'this.namenode.fqdn' => '${this.cluster.name}-nn.${this.domain}',
  'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint",
  #'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint,/export/home/${user.name}/var/lib/checkpoint",
  'hadoop.http.authentication.kerberos.principal' => 'HTTP/${this.fqdn}@${this.realm}',
  'hadoop.proxyuser' => {
    'oozie' => {
      'hosts' => '${this.cluster.name}-wf.${this.domain},wf00.${this.domain},wf01.${this.domain}',
      'groups' => 'hadoopers'
    },
    'httpfs' => {
      'hosts' => '${this.cluster.name}-pxy.${this.domain},pxy00.${this.domain},pxy01.${this.domain}',
      'groups' => 'hadoopers'
    }
  },
  # hdfs-site.xml
  'this.secondary.namenode.fqdn' => '${this.cluster.name}-cn.${this.domain}',
  'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name",
  #'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name,/export/home/${user.name}/var/lib/name",
  'dfs.datanode.kerberos.principal' => 'hdfs/_HOST@${this.realm}',
  'dfs.replication' => '2',
  #'dfs.replication' => '3',
  # mapred-site.xml
  'this.jobtracker.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  'this.jobhistory.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  #'this.jobhistory.fqdn' => '${this.cluster.name}-jh.${this.domain}',
  'mapreduce.tasktracker.kerberos.principal' => 'mapred/_HOST@${this.realm}'
}

#default_attributes

override_attributes(
  'grid' => {
    'etc_root' => grid_etc_root,
    'vol_root' => grid_vol_root,
    'max_vol_nums' => '4'
  },
  'hadoop' => hadoop_attributes
)

