#
# Cookbook Name:: openldap
# Recipe Spec:: client_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'openldap::client' do
  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '7.6') {|node|
      node.set['openldap']['client']['URI'] = 'ldap://ldap.example.com'
      node.set['openldap']['client']['BASE'] = 'dc=example,dc=com'
    }.converge(described_recipe)
  }

  it 'installs ldap-utils package on debian family.' do
    expect(chef_run_on_debian).to install_package('ldap-utils')
  end

  it 'renders /etc/ldap/ldap.conf on debian family.' do
    expected = expect(chef_run_on_debian)
    expected.to render_file('/etc/ldap/ldap.conf').
      with_content(%r|^URI\s+ldap://ldap\.example\.com$|)
    expected.to render_file('/etc/ldap/ldap.conf').
      with_content(%r|^BASE\s+dc=example,dc=com$|)
  end

  let(:chef_run_on_rhel) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0') {|node|
      node.set['openldap']['client']['URI'] = 'ldap://ldap.example.com'
      node.set['openldap']['client']['BASE'] = 'dc=example,dc=com'
    }.converge(described_recipe)
  }

  it 'installs openldap-clients on rhel family.' do
    expect(chef_run_on_rhel).to install_package('openldap-clients')
  end

  it 'renders /etc/openldap/ldap.conf on rhel family.' do
    expected = expect(chef_run_on_rhel)
    expected.to render_file('/etc/openldap/ldap.conf').
      with_content(%r|^URI\s+ldap://ldap\.example\.com$|)
    expected.to render_file('/etc/openldap/ldap.conf').
      with_content(%r|^BASE\s+dc=example,dc=com$|)
  end
end

