name 'ldap-client-grid'
description 'LDAP client role for Grid'

run_list(
  'recipe[ssl_cert::ca_certs]',
  'role[ldap-client]',
  'recipe[openldap::nss-ldapd]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

uri = 'ldap://ldap.grid.example.com/'
base = 'dc=grid,dc=example,dc=com'
ca_name = 'grid_ca'
#ca_cert_file = '/etc/ssl/certs/00grid_ca.crt'

default_attributes(
  'ssl_cert' => {
    'ca_cert_file_prefix' => '00',
    'server_cert_file_prefix' => '01',
    'server_key_file_prefix' => '01',
    'ca_names' => [
      ca_name,
    ],
  },
  'openldap' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'ca_name' => ca_name,
    },
    'client' => {
      'URI' => uri,
      'BASE' => base,
      # because with_ssl_cert_cookbook is set
      #'TLS_CACERT' => ca_cert_file,
      'TLS_REQCERT' => 'allow',
      'TLS_CHECKPEER' => 'yes',
      'SASL_MECH' => 'GSSAPI'
    },
    'nss-ldapd' => {
      'uri' => uri,
      'base' => base,
      'ssl' => 'start_tls',
      # because with_ssl_cert_cookbook is set
      #'tls_cacertfile' => ca_cert_file,
      'tls_reqcert' => 'demand'
    },
    'ldap_lookup_nameservices' => ['passwd', 'group']
  }
)

#override_attributes "apache2" => { "max_children" => "50" }
