#
# Cookbook Name:: concourse-ci
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['concourse-ci']['with_ssl_cert_cookbook'] = false
# If ['concourse-ci']['with_ssl_cert_cookbook'] is true,
# node['concourse-ci']['docker-compose']['config']
# are overridden by the following 'common_name' attributes.
default['concourse-ci']['ssl_cert']['common_name'] = node['fqdn']
default['concourse-ci']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/concourse"
default['concourse-ci']['docker-compose']['pgdata_dir'] = "#{node['concourse-ci']['docker-compose']['app_dir']}/database"
default['concourse-ci']['docker-compose']['web_keys_dir'] = "#{node['concourse-ci']['docker-compose']['app_dir']}/keys/web"
default['concourse-ci']['docker-compose']['worker_keys_dir'] = "#{node['concourse-ci']['docker-compose']['app_dir']}/keys/worker"
default['concourse-ci']['docker-compose']['db_password_reset'] = false
default['concourse-ci']['docker-compose']['db_password_vault_item'] = {
=begin
  'vault' => 'concourse',
  'name' => 'db_password',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'password',  # real hash path: "/password"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
=end
}
default['concourse-ci']['docker-compose']['web_password_reset'] = false
default['concourse-ci']['docker-compose']['web_password_vault_item'] = {
=begin
  'vault' => 'concourse',
  'name' => 'web_password',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'password',  # real hash path: "/password"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
=end
}
default['concourse-ci']['docker-compose']['ssh_keys_reset'] = false

# TODO: support version 2 format, and use `default` instead of `force_override`
force_override['concourse-ci']['docker-compose']['config_format_version'] = '1'
version_1_config = {
  'concourse-db' => {
    'restart' => 'always',
    'image' => 'postgres:9.5',
    'volumes' => [
      #"#{node['concourse-ci']['docker-compose']['pgdata_dir']}:/database",
    ],
    'environment' => {
      'POSTGRES_DB' => 'concourse',
      'POSTGRES_USER' => 'concourse',
      # Note: You should use the `['concourse-ci']['docker-compose']['db_password_vault_item']` attribute.
      'POSTGRES_PASSWORD' => nil,
      'PGDATA' => '/database',
    },
  },
  'concourse-web' => {
    'restart' => 'always',
    'image' => 'concourse/concourse',  # latest, 2.6.0,...
    'links' => [
      'concourse-db',
    ],
    'command' => 'web',
    'ports' => [
      #'8080:8080',  # If you sepecify no value, Chef will sets '8080:8080'.
      #'8443:8443',  # https
    ],
    'volumes' => [
      "#{node['concourse-ci']['docker-compose']['web_keys_dir']}:/concourse-keys",
    ],
    'environment' => {
      #'CONCOURSE_TLS_BIND_PORT' => '8443',  # activate HTTPS
      'CONCOURSE_BASIC_AUTH_USERNAME' => 'concourse',
      # Note: You should use the `['concourse-ci']['docker-compose']['web_password_vault_item']` attribute.
      'CONCOURSE_BASIC_AUTH_PASSWORD' => nil,
      # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
      'CONCOURSE_EXTERNAL_URL' => nil,
      # `<POSTGRES_PASSWORD>` is a placeholder of password string.
      'CONCOURSE_POSTGRES_DATA_SOURCE' => \
        'postgres://concourse:<POSTGRES_PASSWORD>@concourse-db:5432/concourse?sslmode=disable',
    },
  },
  'concourse-worker' => {
    'restart' => 'always',
    'image' => 'concourse/concourse',
    'privileged' => true,
    'links' => [
      'concourse-web',
    ],
    'command' => 'worker',
    'volumes' => [
      "#{node['concourse-ci']['docker-compose']['worker_keys_dir']}:/concourse-keys",
    ],
    'environment' => {
      'CONCOURSE_TSA_HOST' => 'concourse-web',
    },
  },
}

# Not supported yet.
new_config = Marshal.load(Marshal.dump(version_1_config))  # deep copy
new_config['concourse-web'].delete('links')
new_config['concourse-worker'].delete('links')
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => new_config,
}
=begin
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'concourse-db' => {
      'restart' => 'always',
      'image' => 'postgres:9.5',
      'volumes' => [
        #"#{node['concourse-ci']['docker-compose']['pgdata_dir']}:/database",
      ],
      'environment' => {
        'POSTGRES_DB' => 'concourse',
        'POSTGRES_USER' => 'concourse',
        'POSTGRES_PASSWORD' => nil,
        'PGDATA' => '/database',
      },
    },
    'concourse-web' => {
      'restart' => 'always',
      'image' => 'concourse/concourse',  # latest, 2.6.0,...
      'command' => 'web',
      'ports' => [
        #'8080:8080',
      ],
      'volumes' => [
        "#{node['concourse-ci']['docker-compose']['web_keys_dir']}:/concourse-keys",
      ],
      'environment' => {
        'CONCOURSE_BASIC_AUTH_USERNAME' => 'concourse',
        'CONCOURSE_BASIC_AUTH_PASSWORD' => nil,
        'CONCOURSE_EXTERNAL_URL' => nil,
        'CONCOURSE_POSTGRES_DATA_SOURCE' => \
          'postgres://concourse:<POSTGRES_PASSWORD>@concourse-db:5432/concourse?sslmode=disable',
      },
    },
    'concourse-worker' => {
      'restart' => 'always',
      'image' => 'concourse/concourse',
      'privileged' => true,
      'command' => 'worker',
      'volumes' => [
        "#{node['concourse-ci']['docker-compose']['worker_keys_dir']}:/concourse-keys",
      ],
      'environment' => {
        'CONCOURSE_TSA_HOST' => 'concourse-web',
      },
    },
  },
}
=end
default['concourse-ci']['docker-compose']['config'] = \
  node['concourse-ci']['docker-compose']['config_format_version'] == '1' ? version_1_config : version_2_config
