lxcs Cookbook
=============

This cookbook sets up LinuxContainers.org products (LXC, LXD).

## Contents

- [Contents](#contents)
- [Requirements](#requirements)
  - [Platforms](#platforms)
  - [Cookbooks](#cookbooks)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [lxcs::default](#lxcsdefault)
    - [lxcs::lxc](#lxcslxc)
    - [lxcs::lxd](#lxcslxd)
  - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### Platforms

- Ubuntu

### Cookbooks

- None.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['lxcs']['lxc']['env']['lxc']`|Hash|Content in the `/etc/default/lxc`.|See `attributes/default.rb`|
|`['lxcs']['lxc']['env']['lxc-net']`|Hash|Content in the `/etc/default/lxc-net`.|See `attributes/default.rb`|
|`['lxcs']['lxc']['unprivileged_container']['enabled']`|Boolean|Enable unprivileged containers or not|`false`|
|`['lxcs']['lxc']['unprivileged_container']['users_allow']`|Array|root, general users allowed to launch unprivileged_containers on LXC. e.g. `['root', 'alice']`|`[]`|
|`['lxcs']['lxc']['lxc-usernet']`|Array, String|Content (line strings or single string) in the `/etc/lxc/lxc-usernet`.|`[]`, See `attributes/default.rb`|
|`['lxcs']['lxc']['default.conf']`|Array, String|Default initial configuration (profile) file. Content (line strings or single string) in the `/etc/lxc/default.conf`.|See `attributes/default.rb`|
|`['lxcs']['lxc']['extra-default.conf']`|Hash|Additional container configuration (profile) files.|`{}`, See `attributes/default.rb`|
|`['lxcs']['lxd']['with_zfs']`|Boolean|with ZFS utility.|`false`|
|`['lxcs']['lxd']['users_allow']`|Array|Non-root users allowed to manage Linux containers on LXD.|`[]`|
|`['lxcs']['lxd']['init']['enabled']`|Boolean|execute lxd init or not|`false`|
|`['lxcs']['lxd']['init']['force']`|Boolean|re-execute lxd init forcely.|`false`|
|`['lxcs']['lxd']['init']['options']`|String|lxd init command options string.|`''`|
|`['lxcs']['lxd']['init']['trust_password_vault_item']`|Hash|derive LXD server trust password from Chef Vault.|`{}`, See `attributes/default.rb`|
|`['lxcs']['lxd']['network']`|Hash|lxd network configurations. Ubuntu >= 16.10|`{}`, See `attributes/default.rb`|
|`['lxcs']['lxd']['network_force_update']`|Boolean|update lxd network configuration forcely.|`false`|
|`['lxcs']['lxd']['bridge']['enabled']`|Boolean|lxd bridge network configurations. Ubuntu <= 16.04|`false`|
|`['lxcs']['lxd']['bridge']['conf']`|Hash|content in the `/etc/default/lxd-bridge`.|See `attributes/default.rb`|
|`['lxcs']['lxd']['profile']`|Hash|lxd container profile configurations.|`{}`, See `attributes/default.rb`|

## Usage

### Recipes

#### lxcs::default

This recipe does nothing.

#### lxcs::lxc

This recipe installs LXC.

#### lxcs::lxd

This recipe sets up LXD.

### Role Examples

- `roles/lxc.rb`

```ruby
name 'lxc'
description 'LXC role.'

run_list(
  'recipe[lxcs::lxc]',
)

override_attributes(
  'lxcs' => {
    'lxc' => {
      'unprivileged_container' => {
        'enabled' => true,
        'users_allow' => [
          'alice',
          'bob',
        ],
      },
      'lxc-usernet' => [
        'alice veth lxcbr0 10',
        'bob veth lxcbr0 10',
      ],
      'env' => {
        'lxc' => {
          'LXC_AUTO' => 'true',
          'BOOTGROUPS' => 'onboot,',
          'SHUTDOWNDELAY' => '5',
          'OPTIONS' => '',
          'STOPOPTS' => '-a -A -s',
          'USE_LXC_BRIDGE' => 'false',
        },
        'lxc-net' => {
          'USE_LXC_BRIDGE' => 'true',
          'LXC_BRIDGE' => 'lxcbr0',
          'LXC_ADDR' => '10.0.3.1',
          'LXC_NETMASK' => '255.255.255.0',
          'LXC_NETWORK' => '10.0.3.0/24',
          'LXC_DHCP_RANGE' => '10.0.3.2,10.0.3.254',
          'LXC_DHCP_MAX' => '253',
        },
      },
      'default.conf' => [
        'lxc.network.type = veth',
        'lxc.network.link = lxcbr0',
        'lxc.network.flags = up',
        'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
      ],
      'extra-default.conf' => {
        'default-br0.conf' => [
          'lxc.network.type = veth',
          'lxc.network.link = br0',
          'lxc.network.flags = up',
          'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
        ],
        'default-br0-unpriv.conf' => [
          'lxc.network.type = veth',
          'lxc.network.link = br0',
          'lxc.network.flags = up',
          'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
          'lxc.id_map = u 0 100000 65536',
          'lxc.id_map = g 0 100000 65536',
        ],
      },
    },
  },
)
```

- `roles/lxd.rb`

```ruby
name 'lxd'
description 'LXD role.'

run_list(
  'recipe[lxcs::lxd]',
)

override_attributes(
  'lxcs' => {
    'lxd' => {
      'with_zfs' => true,
      'users_allow' => [
        'alice',
        'bob',
      ],
      'init' => {
        'enabled' => true,
        'options' => [
          #"--network-address #{node['ipaddress']}",
          #'--network-port 8443',
          '--storage-backend dir',
          #'--storage-backend zfs',
          #'--storage-create-loop 20',  # 20GB file
          #'--storage-pool lxd',
          # NOT recommended, use 'trust_password_vault_item' attribute.
          #'--trust-password secret',   
        ].join(' '),
      },
      # Ubuntu >= 16.10
      'network' => {
        'lxdbr0' => {
          'config' => {
            'dns.mode' => 'dynamic',
            'ipv4.address' => '10.0.13.1/24',
            'ipv4.dhcp.ranges' => '10.0.13.100-10.0.13.254',
            'ipv4.nat' => 'true',
            'ipv6.address' => 'none',
          },
          'managed' => 'true',
          'type' => 'bridge',
        },
      },
      # Deprecated: Ubuntu <= 16.04
      # use `lxc network set` command on 16.10 (yakkety) or later
      'bridge' => {
        'enabled' => true,
        'conf' => {
          'USE_LXD_BRIDGE' => 'true',
          'LXD_BRIDGE' => 'lxdbr0',
          'UPDATE_PROFILE' => 'true',
          'LXD_CONFILE' => '',
          'LXD_DOMAIN' => 'lxd',
          'LXD_IPV4_ADDR' => '10.0.13.1',
          'LXD_IPV4_NETMASK' => '255.255.255.0',
          'LXD_IPV4_NETWORK' => '10.0.13.1/24',
          'LXD_IPV4_DHCP_RANGE' => '10.0.13.100,10.0.13.254',
          'LXD_IPV4_DHCP_MAX' => '155',
          'LXD_IPV4_NAT' => 'true',
          'LXD_IPV6_ADDR' => '',
          'LXD_IPV6_MASK' => '',
          'LXD_IPV6_NETWORK' => '',
          'LXD_IPV6_NAT' => 'false',
          'LXD_IPV6_PROXY' => 'false',
        },
      },
      'profile' => {
        'default-br0' => {
          'config' => {},
          'description' => 'Default LXD profile for real NIC bridged',
          'devices' => {
            'eth0' => {
              'name' => 'eth0',
              'nictype' => 'bridged',
              'parent' => 'br0',
              'type' => 'nic',
            },
          },
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
