#
# Cookbook Name:: platform_utils
# Recipe:: subid
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

subid_files = [
  '/etc/subuid',
  '/etc/subgid',
]

subid_files.each {|subid_file|
  file subid_file do
    owner 'root'
    group 'root'
    mode '0644'
    action :touch
    not_if { File.exist?(subid_file) }
  end
}

this_recipe = self
node['platform_utils']['subid']['users'].each {|uname|
  ruby_block "adds_subid_entries_#{uname}" do
    action :run
    not_if "cat /etc/subuid | grep #{uname}"
    not_if "cat /etc/subgid | grep #{uname}"
    notifies :restart, 'service[docker]'
    block do
      subid_files.each {|subid_file|
        max_start_id = 100_000
        offset = 0
        already_exist = false

        begin
          File.open(subid_file) {|file|
            file.each_line {|line|
              entry = line.split(':')
              if entry[0] == uname
                already_exist = true
                break
              end
              if entry[1].to_i >= max_start_id
                max_start_id = entry[1].to_i
                offset = entry[2].to_i
              end
            }
          }

          if already_exist
            this_recipe.log "#{uname} already exists in #{subid_file}"
          else
            File.open(subid_file, 'a') {|file|
              entry_str = "#{uname}:#{max_start_id + offset}:65536"
              this_recipe.log "#{uname} (#{entry_str}) is added in #{subid_file}"
              file.puts entry_str
            }
          end
        rescue IOError => e
          puts e
        end
      }
    end
  end
}
