#
# Cookbook Name:: platform_utils
# Recipe:: platform_update
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'shellwords'

if node['platform_utils']['platform_update']['auto_update']
  case node['platform_family']
  when 'debian' then
    update_command = node['platform_utils']['platform_update']['apt-get']['command']
    shellwords = Shellwords.split(update_command)
    unless shellwords[0] == 'apt-get'
      Chef::Log.fatal('You must use apt-get command.')
      raise
    end

    execute 'apt-get_upgrade' do
      user 'root'
      command "apt-get update; #{update_command}"
      action :run
    end
  when 'rhel' then
    update_command = node['platform_utils']['platform_update']['yum']['command']
    shellwords = Shellwords.split(update_command)
    unless shellwords[0] == 'yum'
      Chef::Log.fatal('You must use yum command.')
      raise
    end

    execute 'yum_update' do
      user 'root'
      command update_command
      action :run
    end
  end
end
