#!/bin/sh
#
# Initialize script for Apache Hadoop pseudo distributed mode.
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

HADOOP_PREFIX=<%= node['grid']['app_root'] %>/hadoop
GRID_VOL_ROOT=<%= node['grid']['vol_root'] %>

echo 'Initializing Hadoop ...'

hostname --fqdn
if [ $? -ne 0 ]; then
  echo 'Unknown host! Check the /etc/hosts file and DNS lookup settings.'
  echo 'aborted.'
  exit 1
fi

<% if node['hadoop']['with_security'] then -%>
sudo -u hdfs kinit
<% end -%>
<%
case @major_version
when '1'
-%>
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop namenode -format
echo 'Starting HDFS ...'
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop-daemon.sh start namenode
sudo <%= @datanode_sudo_user_opt %> ${HADOOP_PREFIX}/bin/hadoop-daemon.sh start datanode
echo 'Waiting for HDFS to leave the safe mode ...'
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop dfsadmin -safemode wait
echo 'Setup directories on HDFS ...'
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chown hdfs:hdfs /
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chmod 755 /
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -mkdir /user
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -mkdir ${GRID_VOL_ROOT}/0/var/lib/mapred
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chown mapred:mapred ${GRID_VOL_ROOT}/0/var/lib/mapred
echo 'done.'
echo 'Stopping HDFS ...'
sudo <%= @datanode_sudo_user_opt %> ${HADOOP_PREFIX}/bin/hadoop-daemon.sh stop datanode
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop-daemon.sh stop namenode
<%
when '2'
-%>
sudo -u hdfs ${HADOOP_PREFIX}/bin/hdfs namenode -format
echo 'Starting HDFS ...'
sudo -u hdfs ${HADOOP_PREFIX}/sbin/hadoop-daemon.sh start namenode
sudo <%= @datanode_sudo_user_opt %> ${HADOOP_PREFIX}/sbin/hadoop-daemon.sh start datanode
echo 'Waiting for HDFS to leave the safe mode ...'
sudo -u hdfs ${HADOOP_PREFIX}/bin/hdfs dfsadmin -safemode wait
echo 'Setup directories on HDFS ...'
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chown hdfs:hdfs /
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chmod 755 /
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -mkdir /user
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -mkdir -p ${GRID_VOL_ROOT}/0/var/log/yarn/nm
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chown yarn:hadoop ${GRID_VOL_ROOT}/0/var/log/yarn/nm
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chmod 1777        ${GRID_VOL_ROOT}/0/var/log/yarn/nm
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -mkdir -p ${GRID_VOL_ROOT}/0/var/lib/mapred/history
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chown -R mapred:hadoop ${GRID_VOL_ROOT}/0/var/lib/mapred
sudo -u hdfs ${HADOOP_PREFIX}/bin/hadoop fs -chmod -R 755           ${GRID_VOL_ROOT}/0/var/lib/mapred
echo 'done.'
echo 'Stopping HDFS ...'
sudo <%= @datanode_sudo_user_opt %> ${HADOOP_PREFIX}/sbin/hadoop-daemon.sh stop datanode
sudo -u hdfs ${HADOOP_PREFIX}/sbin/hadoop-daemon.sh stop namenode
<%
end
-%>

echo 'Hadoop initialization complete.'
