jenkins-grid Cookbook
=====================

This cookbook sets up a Jenkins service.

## Contents

- [Requirements](#requirements)
  - [platforms](#platforms)
  - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [jenkins-grid::default](#jenkins-griddefault)
    - [jenkins-grid::docker-compose](#jenkins-griddocker-compose)
  - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- none.

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['jenkins-grid']['with_ssl_cert_cookbook']`|Boolean|If this attribute is true, `node['jenkins-grid']['docker-compose']['config']` are are overridden by the following `common_name` attributes.|`false`|
|`['jenkins-grid']['ssl_cert']['common_name']`|String|Jenkins server common name for TLS|`node['fqdn']`|
|`['jenkins-grid']['num_executors']`|Integer|Number of executors.|`2`|
|`['jenkins-grid']['log.properties']`|Hash|java.util.logging configurations.|See `attributes/default.rb`|
|`['jenkins-grid']['docker-compose']['app_dir']`|String||`"#{node['docker-grid']['compose']['app_dir']}/jenkins"`|
|`['jenkins-grid']['docker-compose']['jenkins_home']['path']`|String|Path string or nil (unset).|`'/var/lib/jenkins_home'`|
|`['jenkins-grid']['docker-compose']['jenkins_home']['owner']`|String, Integer|Jenkins owner user name or uid.|`1000`|
|`['jenkins-grid']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|

## Usage

### Recipes

#### jenkins-grid::default

This recipe does nothing.

#### jenkins-grid::docker-compose

This recipe generates a docker-compose.yml for the Jenkins CI service.

### Role Examples

- `roles/jenkins.rb`

```ruby
name 'jenkins'
description 'Jenkins'

run_list(
  'role[docker]',
  'recipe[jenkins-grid::docker-compose]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'jenkins-grid' => {
    'docker-compose' => {
      'config' => {
        # Version 2 docker-compose format
        'version' => '2',
        'services' => {
          'jenkins' => {
            'restart' => 'always',
            'image' => 'jenkins:2.19.4',
            'ports' => [
              '8080:8080',
              '50000:50000',
            ],
            #'environment' => {
            #},
            #'volumes' => [
            #  # set automatically, if the node['jenkins-grid']['docker-compose']['jenkins_home']['path'] is not nil.
            #  "#{node['jenkins-grid']['docker-compose']['jenkins_home']['path']}:/var/jenkins_home",
            #],
          },
        },
      },
    },
  },
)
```

- `roles/jenkins-with-ssl-cert.rb`

```ruby
name 'jenkins-with-ssl-cert'
description 'Jenkins setup with ssl_cert cookbook'

run_list(
  'recipe[ssl_cert::server_key_pairs]',
  'role[docker]',
  'recipe[jenkins-grid::docker-compose]',
)

#env_run_lists()

#default_attributes()

jenkins_cn = 'jenkins.io.example.com'

override_attributes(
  'jenkins-grid' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => jenkins_cn,
    },
    'docker-compose' => {
      'config' => {
        # Version 2 docker-compose format
        'version' => '2',
        'services' => {
          'jenkins' => {
            'restart' => 'always',
            'image' => 'jenkins:2.19.4',
            'expose' => [
              '8083',  # for https
            ],
            'ports' => [
              '8083:8083',
              '50000:50000',
            ],
            'environment' => {
              'JENKINS_OPTS' => [
                '--httpPort=-1 --httpsPort=8083',
                # These options will be set by the jenkins-grid::docker-compose recipe automatically.
                #'--httpsCertificate=/var/lib/jenkins/server.crt',
                #'--httpsPrivateKey=/var/lib/jenkins/server.key',
              ].join(' '),
            },
            # These volumes will be set by the jenkins-grid::docker-compose recipe automatically.
            #'volumes' => [
            #  "#{node['jenkins-grid']['docker-compose']['jenkins_home']['path']}:/var/jenkins_home",
            #  "#{server_cert_path(node['jenkins-grid']['ssl_cert']['common_name'])}:/var/lib/jenkins/server.crt:ro",
            #  "#{node['jenkins-grid']['docker-compose']['app_dir']}/certs/server.key:/var/lib/jenkins/server.key:ro",
            #],
          },
        },
      },
    },
  },
  'ssl_cert' => {
    'common_names' => [
      jenkins_cn,
    ],
  }
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
