#
# Cookbook Name:: ganglia
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# gmetad.conf
default['ganglia']['data_sources'] = [
  {
    :name => 'my cluster',
    # If the polling interval is omitted, 15sec is asssumed.
    :polling_interval => '',
    # ['address1:port', 'addreses2:port', ...]
    :address_list => ['localhost']
  }
]
default['ganglia']['gridname'] = 'MyGrid'
# e.g. ['127.0.0.1', '169.229.50.165', 'my.gmetad.org']
default['ganglia']['trusted_hosts'] = []

# gmond.conf
default['ganglia']['gmond_conf_type'] = 'static'  # or 'automatic'
## this attribute has effect only if gmond_conf_type is 'static'
default['ganglia']['cluster']['name'] = 'unspecified'
default['ganglia']['cluster']['owner'] = 'unspecified'
default['ganglia']['cluster']['latlong'] = 'unspecified'
default['ganglia']['cluster']['url'] = 'unspecified'
default['ganglia']['host']['location'] = 'unspecified'
## 1. static multi-cast (default)
default['ganglia']['static']['udp_send_channels'] = [
  {
    'mcast_join' => '239.2.11.71',
    'host' => '',
    'port' => '8649',
    'ttl' => '1'
  }
]
default['ganglia']['static']['udp_recv_channels'] = [
  {
    'mcast_join' => '239.2.11.71',
    'port' => '8649',
    'bind' => '239.2.11.71'
  }
]
default['ganglia']['tcp_accept_channels'] = [
  {
    'port' => '8649'
  }
]
=begin
## e.g. 2. static uni-cast
default['ganglia']['static']['udp_send_channels'] = [
  {
    'mcast_join' => '',
    'host' => 'localhost',
    'port' => '8649',
    'ttl' => ''
  }
]
default['ganglia']['static']['udp_recv_channels'] = [
  {
    'mcast_join' => '',
    'port' => '8649',
    'bind' => ''
  }
]
=end
## e.g. 3. automatic multi/uni-cast setup for huge cluster (e.g. Hadoop DataNodes)
default['ganglia']['automatic'] = {
  'cluster_name_prefix' => 'DataNode', # DataNode#####
  'cast_mode' => 'uni',                # or multi
  'domain' => 'grid.example.com',
  'node_prefix' => 'dn',
  'digit_nums' => '5',       # dn#####
  'padstr' => '0',           # dn00000
  'first_node_num' => '0',   # 1st node:  dn00000.grid.example.com
  'last_node_num'  => '999', # last node: dn00999.grid.example.com
  'head_node_nums' => '2',   # heads of the 1st cluster: dn0000{0..1}.grid.example.com
  'cluster_size' => '40',    # heads of the 2nd cluster: dn0004{0..1}.grid.example.com
  'host_format' => 'fqdn',   # fqdn/ip (uni-cast only)
  'mcast_join' => '239.2.11.71', # multi-cast mode only
  'port' => '8649',
  'ttl' => '1',              # multi-cast mode only
  'bind' => '239.2.11.71'    # multi-cast mode only
}

# ganglia-web
## default: white list
default['ganglia']['web']['Order'] = 'Deny,Allow'
default['ganglia']['web']['Deny'] = ['from all']
default['ganglia']['web']['Allow'] = [
  'from 127.0.0.1',
  'from ::1'
]
# AuthType: ''|'Basic'|'Kerberos'
default['ganglia']['web']['AuthType'] = ''
## if AuthType == Basic
default['ganglia']['web']['mod_auth_basic']['AuthUserFile'] = ''
## if AuthType == Kerberos
default['ganglia']['web']['mod_auth_kerb']['KrbAuthRealms'] = 'LOCALDOMAIN'
default['ganglia']['web']['mod_auth_kerb']['KrbServiceName'] = 'HTTP'
default['ganglia']['web']['mod_auth_kerb']['Krb5Keytab'] = '/etc/krb5.keytab'
default['ganglia']['web']['mod_auth_kerb']['KrbMethodNegotiate'] = 'on'
default['ganglia']['web']['mod_auth_kerb']['KrbMethodK5Passwd'] = 'off'
#default['ganglia']['']

