#
# Cookbook Name:: apt_utils
# Attributes:: default
#
# Copyright 2013-2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# apt conf.
default['apt_utils']['conf']['proxy'] = {
  'sequence' => '80',
  'ftp' => nil,
  'http' => nil,
  'https' => nil,
}

default['apt_utils']['source']['apt_lines'] = [
  'deb http://cdn.debian.net/debian wheezy main contrib non-free',
  'deb http://cdn.debian.net/debian wheezy-updates main contrib',
  'deb http://cdn.debian.net/debian wheezy-backports  main contrib non-free',
  'deb http://security.debian.org/ wheezy/updates main contrib non-free',
  # mirror example.
  #'deb http://ftp.grid.example.com/debian wheezy main contrib non-free',
  #'deb http://ftp.grid.example.com/debian wheezy-updates main contrib',
  #'deb http://ftp.grid.example.com/debian wheezy-backports  main contrib non-free',
  # proxy example.
  #'deb http://ftp.grid.example.com:3142/security.debian.org/ wheezy/updates main contrib non-free'
]

default['apt_utils']['aptly']['with_ssl_cert_cookbook'] = false
# If ['apt_utils']['aptly']['with_ssl_cert_cookbook'] is true,
# node['apt_utils']['aptly']['docker-compose']['config']
# are overridden by the following 'common_name' attributes.
default['apt_utils']['aptly']['ssl_cert']['ca_names'] = []
default['apt_utils']['aptly']['ssl_cert']['common_name'] = node['fqdn']
default['apt_utils']['aptly']['apt_repo'] = {
  'keyserver' => 'keys.gnupg.net',
  'recv-keys' => '9E3E53F19C7DE460',
}
default['apt_utils']['aptly']['user'] = 'root'
default['apt_utils']['aptly']['conf'] = {
  # see https://www.aptly.info/doc/configuration/
  'rootDir' => '/var/lib/aptly',
  # for the whitestar/aptly image
  #'rootDir' => '/aptly-data',
  'downloadConcurrency' => 4,
  'downloadSpeedLimit' => 0,
  'architectures' => [],
  'dependencyFollowSuggests' => false,
  'dependencyFollowRecommends' => false,
  'dependencyFollowAllVariants' => false,
  'dependencyFollowSource' => false,
  'gpgDisableSign' => false,
  'gpgDisableVerify' => false,
  'downloadSourcePackages' => false,
  'ppaDistributorID' => 'ubuntu',
  'ppaCodename' => '',
  'skipContentsPublishing' => false,
  'S3PublishEndpoints' => {},
  'SwiftPublishEndpoints' => {},
}
default['apt_utils']['aptly']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/aptly"
default['apt_utils']['aptly']['docker-compose']['etc_dir'] = "#{node['apt_utils']['aptly']['docker-compose']['app_dir']}/etc"
default['apt_utils']['aptly']['docker-compose']['data_dir'] = "#{node['apt_utils']['aptly']['docker-compose']['app_dir']}/data"
force_override['apt_utils']['aptly']['docker-compose']['config_format_version'] = '2'
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'reverseproxy' => {
      'depends_on' => [
        'aptly',
      ],
      'restart' => 'always',
      'image' => 'nginx:alpine',
      'expose' => [
        '8080',
        '8081',
      ],
      'ports' => [
        #'8080:8080',  # distribution service
        #'8081:8081',  # API service
      ],
      'volumes' => [
        # This volume will be set by the apt_utils::aptly-docker-compose recipe automatically.
        #"#{node['apt_utils']['aptly']['docker-compose']['etc_dir']}/nginx/nginx.conf:/etc/nginx/nginx.conf:ro"
      ],
    },
    'aptly' => {
      'restart' => 'always',
      'image' => 'whitestar/aptly',
      # -> reverseproxy
      'ports' => [
        #'8080:8080',  # distribution service
        #'8081:8081',  # API service
      ],
      'volumes' => [
        # This volume will be set by the apt_utils::aptly-docker-compose recipe automatically.
        #"#{node['apt_utils']['aptly']['docker-compose']['data_dir']}:/aptly-data:rw",
      ],
      'environment' => {
      },
    },
  },
}
default['apt_utils']['aptly']['docker-compose']['config'] = version_2_config

default['apt_utils']['apt-cacher-ng']['CacheDir'] = '/var/cache/apt-cacher-ng'
default['apt_utils']['apt-cacher-ng']['LogDir'] = '/var/log/apt-cacher-ng'
default['apt_utils']['apt-cacher-ng']['SupportDir'] = '/usr/lib/apt-cacher-ng'
default['apt_utils']['apt-cacher-ng']['Port'] = '3142'
# Default: not set, will listen on all interfaces and protocols
default['apt_utils']['apt-cacher-ng']['BindAddress'] = ''
default['apt_utils']['apt-cacher-ng']['UseWrap'] = nil  # '0'(default) or '1' (on)

default['apt_utils']['mirror']['user'] = 'apt-mirror'
default['apt_utils']['mirror']['cron_period'] = '#0 4	* * *'  # default: inactive
default['apt_utils']['mirror']['base_path'] = '/var/spool/apt-mirror'
default['apt_utils']['mirror']['nthreads'] = '20'
default['apt_utils']['mirror']['_tilde'] = '0'
default['apt_utils']['mirror']['country'] = 'us'  # or jp,...
# http://www.debian.org/mirror/official
# https://launchpad.net/ubuntu/+archivemirrors
default['apt_utils']['mirror']['distributions']['debian'] = {
  # default: empty (inactive)
  'code_names' => [
    #'wheezy',
    #'wheezy-updates',
    #'wheezy-backports',
    #'squeeze',
  ],
  'architectures' => [
    'amd64',
    'i386',
    #'src',
  ],
  'components' => [
    'main',
    'contrib',
    'non-free',
  ],
}
default['apt_utils']['mirror']['distribution']['ubuntu'] = {
  # default: empty (inactive)
  'code_names' => [
    #'raring',
    #'raring-updates',
    #'raring-security',
  ],
  'architectures' => [
    'amd64',
    'i386'
    #'src',
  ],
  'components' => [
    'main',
    'universe',
    'multiverse',
    'restricted',
  ],
}
