#!/usr/bin/env bash
<%
# NOTE for cookbook developer: If you edit this script, you must update opt/dcos-grid/cloud-config.yaml
-%>

PATH=.:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/bin:`dirname $0`

user=`whoami`
sudo='sudo'
if [ $user = 'root' ]; then
  sudo=''
fi

cd <%= File.dirname(node['dcos-grid']['bootstrap']['genconf_dir']) %>
echo 'Downloading DC/OS release ...'
$sudo curl -O <%= node['dcos-grid']['dcos_release_url'] %>
echo 'Generating DC/OS configurations ...'
$sudo bash dcos_generate_config.sh
echo 'Launching Docker container for the bootstrap service ...'
$sudo docker run -d -p <%= node['dcos-grid']['bootstrap']['port'] %>:80 -v $PWD/genconf/serve:/usr/share/nginx/html:ro nginx
