#
# Cookbook Name:: berkshelf-api-server-ya
# Recipe Spec:: app_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'berkshelf-api-server-ya::app' do
  before {
    stub_command(%r{cd /opt/berkshelf-api/v\d+\.\d+\.\d+ && /opt/chef/embedded/bin/bundle check})
      .and_return(true)
  }

  let(:chef_run) {
=begin
    ChefSpec::SoloRunner.new {|node|
      node.override[:berkshelf_api][:app_host] = '127.0.0.1'
    }.converge(described_recipe)
=end
    ChefSpec::SoloRunner.new(step_into: ['runit_service']) {|node|
      node.override[:berkshelf_api][:app_host] = '127.0.0.1'
    }.converge(described_recipe)
  }

  it 'changes bind address to 127.0.0.1 in /etc/sv/berks-api/run through runit_service LWRP' do
    expect(chef_run).to \
      render_file('/etc/sv/berks-api/run')
      .with_content(%r{\s+bin/berks-api -h 127\.0\.0\.1\s+})
  end
end
