#
# Cookbook Name:: nagios
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['nagios']['cluster_name'] = 'localhost'
# default: white list
default['nagios']['web']['Order'] = 'Deny,Allow'
default['nagios']['web']['Deny'] = ['from all']
default['nagios']['web']['Allow'] = [
  'from 127.0.0.1',
  'from ::1'
]
# AuthType: ''|'Basic'|'Kerberos'
default['nagios']['web']['AuthType'] = 'Basic'
## if AuthType == Basic
default['nagios']['web']['mod_auth_basic']['AuthUserFile'] = node.value_for_platform_family(
  'debian' => '/etc/nagios3/htpasswd.users',
  'rhel'   => '/etc/nagios/passwd'
)
## if AuthType == Kerberos
default['nagios']['web']['mod_auth_kerb']['KrbAuthRealms'] = 'LOCALDOMAIN'
default['nagios']['web']['mod_auth_kerb']['KrbServiceName'] = 'HTTP'
default['nagios']['web']['mod_auth_kerb']['Krb5Keytab'] = '/etc/krb5.keytab'
default['nagios']['web']['mod_auth_kerb']['KrbMethodNegotiate'] = 'on'
default['nagios']['web']['mod_auth_kerb']['KrbMethodK5Passwd'] = 'off'
# nagios.cfg
default['nagios']['check_external_commands'] = '0'
default['nagios']['command_file'] = node.value_for_platform_family(
  'debian' => '/var/lib/nagios3/rw/nagios.cmd',
  'rhel' => '/var/spool/nagios/cmd/nagios.cmd'
)
default['nagios']['use_regexp_matching'] = '0'
# cgi.cfg
default['nagios']['authorized_for_system_information'] = 'nagiosadmin'
default['nagios']['authorized_for_configuration_information'] = 'nagiosadmin'
default['nagios']['authorized_for_system_commands'] = 'nagiosadmin'
default['nagios']['authorized_for_all_services'] = 'nagiosadmin'
default['nagios']['authorized_for_all_hosts'] = 'nagiosadmin'
default['nagios']['authorized_for_all_service_commands'] = 'nagiosadmin'
default['nagios']['authorized_for_all_host_commands'] = 'nagiosadmin'
# check_ganglia_metric
default['nagios']['NagAconda']['version'] = '0.1.4'
#default['nagios']['NagAconda']['version'] = '0.2.1'
default['nagios']['check_ganglia_metric']['enabled'] = false
default['nagios']['check_ganglia_metric']['gmetad_host'] = 'localhost'
# objects
default['nagios']['objects']['commands'] = []
default['nagios']['objects']['hosts'] = []
default['nagios']['objects']['hostgroups'] = []
default['nagios']['objects']['hostdependencies'] = []
default['nagios']['objects']['hostescalations'] = []
default['nagios']['objects']['hostextinfos'] = []
default['nagios']['objects']['services'] = []
default['nagios']['objects']['servicegroups'] = []
default['nagios']['objects']['servicedependencies'] = []
default['nagios']['objects']['serviceescalations'] = []
default['nagios']['objects']['serviceextinfos'] = []
default['nagios']['objects']['contacts'] = []
default['nagios']['objects']['contactgroups'] = []
default['nagios']['objects']['timeperiods'] = []

#default['nagios']['']

