#
# Cookbook Name:: screwdriver
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['screwdriver']['with_ssl_cert_cookbook'] = false
# If ['screwdriver']['with_ssl_cert_cookbook'] is true,
# node['screwdriver']['docker-compose']['config']
# are overridden by the following 'common_name' attributes.
default['screwdriver']['ssl_cert']['ca_names'] = []
default['screwdriver']['ssl_cert']['common_name'] = node['fqdn']
cn = node['screwdriver']['ssl_cert']['common_name']

# These hash objects are expanded to a `/config/local.yaml` file in each Docker container.
default['screwdriver']['api']['config'] = {
  'auth' => {},
  'httpd' => {
    'tls' => false,
  },
}
default['screwdriver']['store']['config'] = {
  'auth' => {},
  'httpd' => {
    'tls' => false,
  },
}

# Useless?!
force_override['screwdriver']['docker-compose']['import_ca'] = false
default['screwdriver']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/screwdriver"
default['screwdriver']['docker-compose']['bin_dir'] = "#{node['screwdriver']['docker-compose']['app_dir']}/bin"
default['screwdriver']['docker-compose']['config_dir'] = "#{node['screwdriver']['docker-compose']['app_dir']}/config"
default['screwdriver']['docker-compose']['data_dir'] = "#{node['screwdriver']['docker-compose']['app_dir']}/data"
default['screwdriver']['docker-compose']['jwt_private_key_reset'] = false
default['screwdriver']['docker-compose']['jwt_private_key_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'jwt_private_key',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'private',  # real hash path: "/password"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/private',  # real hash path: "/#{node.chef_environment}/hash/path/to/private"
=end
}
default['screwdriver']['docker-compose']['jwt_public_key_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'jwt_public_key',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'public',  # real hash path: "/password"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/public',  # real hash path: "/#{node.chef_environment}/hash/path/to/public"
=end
}
# A password used for encrypting session data. Needs to be minimum 32 characters
default['screwdriver']['docker-compose']['cookie_password_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'cookie_password',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'password',  # real hash path: "/password"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
=end
}
# A password used for encrypting stored secrets. Needs to be minimum 32 characters
default['screwdriver']['docker-compose']['password_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'password',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'password',  # real hash path: "/password"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
=end
}
default['screwdriver']['docker-compose']['oauth_client_id_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'oauth_client_id',
  # single cid or nested hash cid path delimited by slash
  'env_context' => false,
  'key' => 'cid',  # real hash path: "/cid", Note: do not use `id`, which is preserved by Chef Vault.
  # or nested hash id path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/cid',  # real hash path: "/#{node.chef_environment}/hash/path/to/cid"
=end
}
default['screwdriver']['docker-compose']['oauth_client_secret_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'oauth_client_secret',
  # single secret or nested hash secret path delimited by slash
  'env_context' => false,
  'key' => 'secret',  # real hash path: "/secret"
  # or nested hash secret path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/secret',  # real hash path: "/#{node.chef_environment}/hash/path/to/secret"
=end
}
default['screwdriver']['docker-compose']['webhook_github_secret_vault_item'] = {
=begin
  'vault' => 'screwdriver',
  'name' => 'webhook_github_secret',
  # single password or nested hash password path delimited by slash
  'env_context' => false,
  'key' => 'secret',  # real hash path: "/secret"
  # or nested hash password path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/secret',  # real hash path: "/#{node.chef_environment}/hash/path/to/secret"
=end
}

# ref: https://github.com/screwdriver-cd/screwdriver/blob/master/in-a-box.py
force_override['screwdriver']['docker-compose']['config_format_version'] = '2'
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'api' => {
      'image' => 'screwdrivercd/screwdriver:stable',
      'command' => 'npm start',  # the original command in the Dockerfile.
      'ports' => [
        #'9001:80',  # default
      ],
      'volumes' => [
        '/var/run/docker.sock:/var/run/docker.sock:rw',
        # This volume will be set by the screwdriver::docker-compose recipe automatically.
        #"#{node['screwdriver']['docker-compose']['data_dir']}:/sd-data:rw",
      ],
      'environment' => {
        # See:
        # http://docs.screwdriver.cd/cluster-management/configure-api
        # https://github.com/screwdriver-cd/screwdriver/blob/master/config/custom-environment-variables.yaml
        'PORT' => '80',
        'URI' => "http://#{cn}:9001",
        #'URI' => "http://#{node['ipaddress']}:9001",  # unrecommended
        # These vriables will be set by the screwdriver::docker-compose recipe automatically.
        #'ECOSYSTEM_UI' => 'http://ui',                         # NG: for an access from a client.
        #'ECOSYSTEM_UI' => "http://#{cn}:9000",                 # Better
        #'ECOSYSTEM_UI' => "http://#{node['ipaddress']}:9000",  # unrecommended
        #'ECOSYSTEM_STORE' => 'http://store',
        #'ECOSYSTEM_STORE' => "http://#{cn}:9002",                 # Better
        #'ECOSYSTEM_STORE' => "http://#{node['ipaddress']}:9002",  # unrecommended
        'SECRET_WHITELIST' => '[]',
        'SECRET_ADMINS' => '[]',
        'DATASTORE_PLUGIN' => 'sequelize',
        'DATASTORE_SEQUELIZE_DIALECT' => 'sqlite',
        'DATASTORE_SEQUELIZE_STORAGE' => '/sd-data/storage.db',
        'EXECUTOR_PLUGIN' => 'docker',
        'EXECUTOR_DOCKER_DOCKER' => <<-'EOS',
{
  "socketPath": "/var/run/docker.sock"
}
EOS
        #'NODE_TLS_REJECT_UNAUTHORIZED' => '0',  # workaround for self-signed cetificates
        #
        # SCM settings
        #   - Note: Multiple SCMs not supported yet.
        #     https://github.com/screwdriver-cd/screwdriver/issues/365
        #   - OAuth Callback URL: "http://#{cn}:9001/v4/auth/login/web"
        #'SCM_PLUGIN' => 'github',  # or 'gitlab' or 'bitbucket'
        # * Commons
        #'SCM_USERNAME' => 'sd-buildbot',
        #'SCM_EMAIL' => 'dev-null@screwdriver.cd',
        # The following variables will be set by the screwdriver::docker-compose recipe automatically.
        #'SECRET_OAUTH_CLIENT_ID' => '${SECRET_OAUTH_CLIENT_ID}',
        #'SECRET_OAUTH_CLIENT_SECRET' => '${SECRET_OAUTH_CLIENT_SECRET}',
        # * GitHub only
        #'WEBHOOK_GITHUB_SECRET' => '${WEBHOOK_GITHUB_SECRET}',  #'SUPER-SECRET-SIGNING-THING'
        #'SCM_GITHUB_GHE_HOST' => 'gitlab.io.example.com',  # for GHE
        #'SCM_PRIVATE_REPO_SUPPORT' => 'false',
        # * GitLab only
        #'SCM_GITLAB_HOST' => 'gitlab.io.example.com',
        #'SCM_GITLAB_PROTOCOL' => 'https',
        # * Bitbucket only
        #   None.
        #
        # The following variables will be set by the screwdriver::docker-compose recipe automatically.
        #'SECRET_JWT_PRIVATE_KEY' => '${SECRET_JWT_PRIVATE_KEY}',
        #'SECRET_JWT_PUBLIC_KEY' => '${SECRET_JWT_PUBLIC_KEY}',
        #'IS_HTTPS' => 'false',
      },
    },
    'ui' => {
      'image' => 'screwdrivercd/ui:stable',
      'ports' => [
        #'9000:80',  # default
      ],
      'environment' => {
        # These variables will be set by the screwdriver::docker-compose recipe automatically.
        #'ECOSYSTEM_API' => 'http://api',                        # NG: for an access from a client.
        #'ECOSYSTEM_API' => "http://#{cn}:9001",                 # Better
        #'ECOSYSTEM_API' => "http://#{node['ipaddress']}:9001",  # unrecommended
        #'ECOSYSTEM_STORE' => 'http://store',
        #'ECOSYSTEM_STORE' => "http://#{cn}:9002",                 # Better
        #'ECOSYSTEM_STORE' => "http://#{node['ipaddress']}:9002",  # unrecommended
      },
    },
    'store' => {
      'image' => 'screwdrivercd/store:stable',
      'ports' => [
        #'9002:80',  # default
      ],
      'environment' => {
        # See https://github.com/screwdriver-cd/store/blob/master/config/custom-environment-variables.yaml
        'PORT' => '80',
        'URI' => "http://#{cn}:9002",
        #'URI' => "http://#{node['ipaddress']}:9002",  # unrecommended
        #'STRATEGY' => 'memory',
        # These variables will be set by the screwdriver::docker-compose recipe automatically.
        #'ECOSYSTEM_UI' => 'http://ui',          # NG for an access from a client.
        #'ECOSYSTEM_UI' => "http://#{cn}:9000",  # Better
        #'ECOSYSTEM_UI' => "http://#{node['ipaddress']}:9000",
        #'SECRET_JWT_PUBLIC_KEY' => '${SECRET_JWT_PUBLIC_KEY}',
      },
    },
  },
}

default['screwdriver']['docker-compose']['config'] = version_2_config
