$LOAD_PATH.push("#{File.dirname(__FILE__)}/../_lib")
#${chef-repo}/_lib/grid.rb
require 'grid'

name 'grid-realm'
description 'The Grid realm configurations.'

run_list(
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
)

override_attributes(
  'krb5' => {
    'libdefaults' => {
      'default_realm' => Grid::REALM,
      # strong crypto
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
      # or weak crypto for 1.0.x KSSL
      #'allow_weak_crypto' => 'true',
      #'default_tgs_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      #'default_tkt_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      #'permitted_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
    },
    'realms' => {
      Grid::REALM => {
        'kdcs' => "ns0{0..2}.#{Grid::DOMAIN}".expand,
        'admin_server' => "krb-admin.#{Grid::DOMAIN}"
      }
    },
    'domain_realms' => [
      ".#{Grid::DOMAIN} = #{Grid::REALM}"
    ]
  },
  'hadoop' => {
    # for 1.0.x KSSL on the JDK 6 only >>
    'krb5_strong_crypto' => {
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
    },
    'krb5_weak_crypto' => {
      'default_tgs_enctypes' \
        => 'des-cbc-crc des-cbc-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
    }
    # <<
  }
)
