#
# Cookbook Name:: krb5
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['krb5']['libdefaults']['default_realm'] = 'LOCALDOMAIN'
default['krb5']['libdefaults']['allow_weak_crypto'] = 'false'
default['krb5']['libdefaults']['default_tgs_enctypes'] = nil
default['krb5']['libdefaults']['default_tkt_enctypes'] = nil
default['krb5']['libdefaults']['permitted_enctypes'] = nil
## for strong crypto
#default['krb5']['libdefaults']['default_tgs_enctypes'] = 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
#default['krb5']['libdefaults']['default_tkt_enctypes'] = 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
#default['krb5']['libdefaults']['permitted_enctypes'] = 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
## for weak crypto (Hadoop 1.0 KSSL on the JDK 6)
#default['krb5']['libdefaults']['allow_weak_crypto'] = 'true'
#default['krb5']['libdefaults']['default_tgs_enctypes'] = 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
#default['krb5']['libdefaults']['default_tkt_enctypes'] = 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
#default['krb5']['libdefaults']['permitted_enctypes'] = 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
default['krb5']['realms'] = {
  node['krb5']['libdefaults']['default_realm'] => {
    'kdcs' => [
      'localhost'
    ],
    'admin_server' => 'localhost'
  }
}
default['krb5']['domain_realms'] = [
  'localhost = LOCALDOMAIN'
]

default['krb5']['kpropd.acl'] = ''
=begin
# e.g. list KDCs
default['krb5']['kpropd.acl'] = <<-EOC
host/ns00.grid.example.com@GRID.EXAMPLE.COM
host/ns01.grid.example.com@GRID.EXAMPLE.COM
EOC
=end
#default['krb5'][''] = ''
