#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

cluster_name = 'praesepe'
cluster_sym = cluster_name.to_sym
hadoop_version = '1.2.1'
hbase_version = '0.94.7'

name "#{cluster_name}-node"
description "#{cluster_name.capitalize} cluster node"

run_list(
  "role[hadoop-#{cluster_name}]",
  #"role[hadoop-#{cluster_name}-with-security]",
  #"role[hbase-#{cluster_name}-with-security]"
)

#env_run_lists()

cluster = Grid::CLUSTERS[cluster_sym]

default_attributes(
  'hadoop' => {
    'version' => hadoop_version,
    'metrics2' => {
      # multi-cast
      'namenode.sink.ganglia.servers'    => "#{cluster[:namenodes][:mcast_addr]}:8649",
      'datanode.sink.ganglia.servers'    => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'jobtracker.sink.ganglia.servers'  => "#{cluster[:jobtrackers][:mcast_addr]}:8649",
      'tasktracker.sink.ganglia.servers' => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'maptask.sink.ganglia.servers'     => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'reducetask.sink.ganglia.servers'  => "#{cluster[:datanodes][:mcast_addr]}:8649"
    }
  },
=begin
  'hbase' => {
    'version' => hbase_version
  }
=end
)

#override_attributes()

