//---------------------------< /-/ AMSL /-/ >------------------------------
/**
 * file         :       virtual_wall.cpp
 *
 *
 * Environment  :       g++
 * Latest Update:       2011/05/24
 *
 * Designer(s)  :       m.mitsuhashi (AMSL)
 * Author(s)    :       y.nishikawa (AMSL)
 *
 * CopyRight    :       2011, Autonomous Mobile Systems Laboratory, Meiji Univ.
 *
 * Revision     :       2011/05/24
 *
 */
//-----------------------------------------------------------------------------

#include <ros/ros.h>

#include <joy/Joy.h>
#include <roomba_500driver_meiji/RoombaCtrl.h>
#include <roomba_500driver_meiji/Roomba500State.h>
#include <diagnostic_msgs/DiagnosticArray.h>

#include <boost/thread.hpp>
boost::mutex cntl_mutex_;
boost::mutex bumper_mutex_;
boost::mutex ball_mutex_;

#include <iostream>
#include <math.h>

#include<stdio.h>
#include<stdlib.h>
#include<time.h>

using namespace std;

joy::Joy joy_in;
ros::Publisher pub_state;

roomba_500driver_meiji::Roomba500State state;
diagnostic_msgs::DiagnosticArray ball_flag_;

roomba_500driver_meiji::RoombaCtrl old_ctrl;
int old_mode = 0;

int flag = 0;
int bumper_flag = 0;
int counter= 0;
int tmp = 0;
float v, yawrate;

void states_callback(const roomba_500driver_meiji::Roomba500StateConstPtr& msg){
	boost::mutex::scoped_lock(bumper_mutex_);
	state = *msg;
}

void ball_callback(const diagnostic_msgs::DiagnosticArrayConstPtr& msg){
	boost::mutex::scoped_lock(ball_mutex_);
	ball_flag_ = *msg;
}

void return_mode(float yaw, float threshold_yaw){
	if(fabs(yaw) >= threshold_yaw * M_PI / 180.0){
		flag = 0;
		bumper_flag = 0;
		counter= 0;	
	}
}

void control(){
	diagnostic_msgs::DiagnosticArray ball_flag;
	
	roomba_500driver_meiji::RoombaCtrl ctrl;
	ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE;
	
	{
	boost::mutex::scoped_lock(ball_mutex_);
	ball_flag = ball_flag_;
	}
	
	cout<<"-------------------"<<endl;

	//通常は直進させる
	if(state.bump.left == 0 && state.bump.right== 0){

		ctrl.cntl.linear.x=0.001*roomba_500driver_meiji::RoombaCtrl::DEFAULT_VELOCITY*1.0;
		ctrl.cntl.angular.z=0.000;

		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
	}
	
	//cout<<"V = "<<ctrl.cntl.linear.x<<endl;
	
	float v_gain		= 0.1;	//前進方向のゲイン
	float avoid_yawrate	= 0.5;	//回避の回頭速度 [m/s]

	//cout<<"bumper_left  = "<<state.bump.left<<endl;
	//cout<<"bumper_right = "<<state.bump.right<<endl;

	// 壁の検知のしきい値（大きくすると近くで　小さくすると遠くで検知する）
	int light_threshold = 100; //150
	
	//六つのレーザから最大の値（壁に最も近い方向）を検索するため
	int max_light_value = 0;
	int max_light_number= 0;

	//ルンバ内臓のレーザの値を参照して格納
	//レーザの位置は全体的に右寄りです
	int light_value[6];
	light_value[0] = state.light_bumper.left;
	light_value[1] = state.light_bumper.front_left;
	light_value[2] = state.light_bumper.center_left;
	light_value[3] = state.light_bumper.center_right;
	light_value[4] = state.light_bumper.front_right;
	light_value[5] = state.light_bumper.right;

	for(int i=0;i<6;i++){
		//light_valueの中から最大値を見つける
		if(light_value[i] > max_light_value){	
		//if(light_value[i] > light_threshold && light_value[i] > max_light_value){	
			max_light_value  = light_value[i];
			max_light_number = i+1;
		}
	}

	//cout<<"max_light_number = "<<max_light_number<<endl; 
	//cout<<"max_light_vlue   = "<<max_light_value<<endl; 

	//物体に接近したときに減速する
	if(max_light_value > light_threshold * 0.8){
		ctrl.cntl.linear.x=0.001*roomba_500driver_meiji::RoombaCtrl::DEFAULT_VELOCITY*0.25;
		//ctrl.cntl.angular.z=0.0;
		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
	}
	if(flag != 3){	
		if(light_value[0] > 65){
			ctrl.cntl.linear.x=0.0;
			ctrl.cntl.angular.z=-0.7;
			ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
		}
		if(max_light_value > light_threshold){
			if(max_light_number == 1){
				ctrl.cntl.linear.x=0.0;
				ctrl.cntl.angular.z=-0.7;
				ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
				flag = 2;
			}else if(max_light_number >= 3){
				ctrl.cntl.linear.x=0.0;
				ctrl.cntl.angular.z=0.7;
				ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
				flag = 2;//*/
			}
		}
	}
	
	//virtual wall mode
	bool virtual_wall = state.virtual_wall;
	if(virtual_wall == true){
		ctrl.cntl.linear.x=0.0;
		ctrl.cntl.angular.z=-0.7;
		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
		//flag = 2;
	}

	cout<<"virtual_wall flag = "<<virtual_wall<<endl;
	
	//cout<<"V = "<<ctrl.cntl.linear.x<<endl;
	//cout<<"flag = "<<flag<<endl;

	//左のバンパーにぶつかった場合は右回頭
	if(state.bump.left == true && state.bump.right == false){
	//if(state.bump.left == 1 && state.bump.right == 0){
		ctrl.cntl.linear.x=-0.001*roomba_500driver_meiji::RoombaCtrl::DEFAULT_VELOCITY*v_gain*0;
		ctrl.cntl.angular.z=(float)(-avoid_yawrate);

		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
		flag = 1;
	}
	//右のバンパーにぶつかった場合は左回頭
	if(state.bump.left == false && state.bump.right== true){
	//if(state.bump.left == 0 && state.bump.right== 1){
		ctrl.cntl.linear.x=-0.001*roomba_500driver_meiji::RoombaCtrl::DEFAULT_VELOCITY*v_gain*0;
		ctrl.cntl.angular.z=(float)(avoid_yawrate);

		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
		flag = 1;
	}
	
	//正面のバンパーにぶつかった場合は180°回頭
	if(state.bump.left == true && state.bump.right== true){
	//if(state.bump.left == 1 && state.bump.right== 1){
		ctrl.cntl.linear.x=-0.001*roomba_500driver_meiji::RoombaCtrl::DEFAULT_VELOCITY*v_gain*0;
		ctrl.cntl.angular.z=(float)(avoid_yawrate);

		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
		flag = 1;	
	}

	diagnostic_msgs::DiagnosticStatus ball_flag_status;
	
	//ぶつかったときに回避方向の保存
	if(counter == 0){
		v       = ctrl.cntl.linear.x;
		yawrate = ctrl.cntl.angular.z;
	}
	
	float yaw = 0;
	
	//回避運動を入力
  if(flag>0){
		counter++;
		ctrl.cntl.linear.x=v;
		ctrl.cntl.angular.z=yawrate;
		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::DRIVE_DIRECT;
		//変化がある場合に初期化
		/*if(bumper_flag && (state.bump.left || state.bump.right)){
			cout<<"test"<<endl;
			flag    = 0;
			counter = 0;
		}*/
		
		yaw = ctrl.cntl.angular.z * counter*0.05;
		
	}
	
	//バンパーがぶつかったとき乱数で避ける角度を決定する
	int bumper_avoid_theta;
	int laser_avoid_theta;
	srand((unsigned)time(NULL));
	bumper_avoid_theta = rand() % 120 + 10;
	laser_avoid_theta   = rand() % 50  + 45; 

	//角度の積算で元に戻す
	if(flag == 1){
		//return_mode(yaw, 30);
		return_mode(yaw, bumper_avoid_theta);
	}else if(flag == 2){
		//return_mode(yaw, 45);
		return_mode(yaw, laser_avoid_theta);
	}else if(flag == 3){
		return_mode(yaw, 120);
	}
	
	//cout<<"V = "<<ctrl.cntl.linear.x<<endl;
	//cout<<"Y = "<<ctrl.cntl.angular.z<<endl;

	//最初にブラシを起動させるか
	/*if(tmp<40){
		ctrl.mode=roomba_500driver_meiji::RoombaCtrl::MOTORS;
		
	}*/
	tmp++;

	pub_state.publish(ctrl);
}

int main(int argc, char** argv) {
	
  ros::init(argc, argv, "virtual_ball");
  ros::NodeHandle n;

	pub_state=n.advertise<roomba_500driver_meiji::RoombaCtrl>("/roomba/control", 100);
	ros::Subscriber state_sub = n.subscribe("/roomba/states", 100, states_callback);
	//ros::Subscriber ball_sub  = n.subscribe("/masterpiece/judge", 100, ball_callback);

	ros::Rate loop_rate(20);
	while(ros::ok()){
	
		control();
		ros::spinOnce();
		loop_rate.sleep();
    
	}
	return 0;
}

