using System;
using System.Diagnostics;
using System.Collections.Generic;
namespace mdc5linker{
	class ToMain{
#if DEBUG
		static readonly string PATH = @"D:/work/mdc5/linker/";
#else
		static readonly string PATH = System.Windows.Forms.Application.StartupPath + @"\";
#endif
		public const string VERSION = "mdc5 linker version 0.3.1\n";

		[System.STAThreadAttribute()] //for System.Windows.Forms.FolderBrowserDialog
		static void Main(string[] argv)
		{
			Interface.Konfig config = new Interface.Konfig(PATH);
			if(config.FileLoad() == false){
				if(config.PathConfigutation() == false){
					return;
				}
			}
			if(argv.Length == 0){
				mdc5linker.imageselecter t = new mdc5linker.imageselecter(config);
				System.Windows.Forms.Application.EnableVisualStyles();
				//System.Windows.Forms.Application.SetCompatibleTextRenderingDefault(false);
				System.Windows.Forms.Application.Run(t);
				return;
			}

			if(argv[0] == "-l"){
				CuiLogger log = new CuiLogger();
				Interface.Scanner s = new Interface.Scanner();
				log.Subscribe(s);
				s.HashlistScreenOut(config.PathGet("diskimage.in"), config.PathGet("romimage.in"));
			}else if((argv[0] == "-f") && (argv.Length >= 2)){
				Queue<string> list = new Queue<string>(argv);
				list.Dequeue();
				analyze(list.ToArray());
			}else{
				Console.Write(VERSION);
				ConsoleLinker linker = new ConsoleLinker();
				if(linker.LoadArgument(argv) != false){
					linker.Link(config);
				}
			}
		}
		static void analyze(string [] list)
		{
			foreach(string image in list){
				imagefile.Fds f = new imagefile.Fds();
				imagefile.Nes n = new imagefile.Nes();
				imagefile.GameImage g;
				if(list.Length != 1){
					Console.WriteLine(image);
				}
				if(f.Load(image) == true){
					g = f;
					foreach(string t in f.FilesystemShow()){
						Console.WriteLine(t);
					}
				}else if(n.Load(image) == true){
					g = n;
				}else{
					Console.WriteLine(image + "open or filesystem error");
					continue;
				}
				List<string> hashlist = new List<string>();
				g.HashListAdd(hashlist);
				foreach(string t in hashlist.ToArray()){
					Console.WriteLine(t);
				}
			}
		}
	}

	class ConsoleLinker{
		bool m_output_nes = false, m_output_bin = false;
		bool m_do_patch = true;
		string m_output_prefix = "";
		string [] m_input_image;
		int m_romsize = imagestream.Manage.ROM_CAPACITY_AUTO;
		
		bool capacity_get(string str, ref int capacity)
		{
			int M = 0x20000;
			switch(str){
			case "Auto":
				m_romsize = imagestream.Manage.ROM_CAPACITY_AUTO;
				break;
			case "512K":
				capacity = M / 2;
				break;
			case "1M":
				capacity = 1 * M;
				break;
			case "2M":
				capacity = 2 * M;
				break;
			case "4M":
				capacity = 4 * M;
				break;
			case "8M":
				capacity = 8 * M;
				break;
			}
			return true;
		}
		public bool LoadArgument(string[] argv)
		{
			Queue<string> t = new Queue<string>(argv);
			List<string> fdslist = new List<string>();
			while(t.Count != 0){
				string argv0 = t.Dequeue();
				switch(argv0){
				case "-o":
					if(t.Count == 0){
						Console.Write("argument Error {0}", argv0);
						return false;
					}
					m_output_prefix = t.Dequeue();
					break;
				case "-n":
					m_output_nes = true;
					break;
				case "-b":
					m_output_bin = true;
					break;
				case "-c":
					if(t.Count == 0){
						Console.Write("argument Error {0}", argv0);
						return false;
					}
					string cap = t.Dequeue();
					if(capacity_get(cap, ref m_romsize) == false){
						Console.Write("unknown capacity {0}", cap);
						return false;
					}
					break;
				case "-l":
				case "-f":
					Console.Write("argument Error {0}", argv0);
					return false;
				case "-q":
					m_do_patch = false;
					break;
				default:
					fdslist.Add(argv0);
					break;
				}
			}
			m_input_image = fdslist.ToArray();
			return true;
		}
		public void Link(Interface.Konfig config)
		{
			CuiLogger log = new CuiLogger();
			Interface.Scanner s = new Interface.Scanner();
			log.Subscribe(s);

			mdc5.Script [] script_list;
			if(s.FilenameToScript(m_input_image, config.PathGet("diskscript.in"), out script_list) == false){
				Console.Write("script not found");
				return;
			}
			if(m_output_prefix == ""){
				if(config.RomnameAutoattach == true){
					m_output_prefix = AutoFilenameGet(script_list);
				}else{
					m_output_prefix = "mdc5";
				}
			}
			config.RomCapacity = m_romsize;
			config.OutputBin = m_output_bin;
			config.OutputNes = m_output_nes;
			mdc5.GameImage m = new mdc5.GameImage();
			log.Subscribe(m);
			m.BatchLink(
				config, script_list, 
				m_output_prefix,
				m_do_patch, true
			);
		//	config.FileSave();
		}
		static public string AutoFilenameGet(mdc5.Script [] list)
		{
			string ret = "";
			foreach(mdc5.Script s in list){
				System.Text.RegularExpressions.GroupCollection g;
				string pattern = "";
				switch(s.ImageType){
				case mdc5.Script.imagetype.disk:
					pattern = @"^([0-9A-Z]{3})\-([0-9A-Z]{3,4})";
					pattern += @"(,([0-9A-Z]{3})\-([0-9A-Z]{3,4}))?$"; //2毎目の型番はなくてもよい
					break;
				case mdc5.Script.imagetype.rom:
					pattern = @"^([0-9A-Z]{3})\-([0-9A-Z]{2})";
					break;
				}
				Debug.Assert(s.ImageType != mdc5.Script.imagetype.undef);
				if(Static.Utility.matching(s.GameCode, pattern, out g) == true){
					ret += g[2].Value.ToLower() + "_";
					if(g[5].Value != ""){
						ret += g[5].Value.ToLower() + "_";
					}
				}else{
					ret += s.GameCode.ToLower() + "_";
				}
			}
			return ret.Substring(0, ret.Length - 1);
		}
	}
}
