using System;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;

namespace Static
{
	class Utility
	{
		public static bool matching(string target, string pattern, out GroupCollection g)
		{
			Match match = new Regex(pattern).Match(target);
			g = match.Groups;
			return match.Success;
		}
		public static bool matching(string target, string pattern)
		{
			Match match = new Regex(pattern).Match(target);
			return match.Success;
		}
		public static string string_forward(string r, int num)
		{
			return r.Substring(num, r.Length - num);
		}
		public static bool text_load(string filename, out string[] ret)
		{
			try{
				List<string> q = new List<string>();
				FileInfo info = new FileInfo(filename);
				StreamReader f = info.OpenText();
				do{
					string t = f.ReadLine();
					if(t == null){
						break;
					}
					q.Add(t);
				}while(q.Count < 1000);
				f.Close();
				ret = q.ToArray();
				return true;
			}catch{
				ret = null;
				return false;
			}
		}
		public static bool text_save(string filename, string[] data)
		{
			try{
				StreamWriter f = new StreamWriter(filename, false);
				foreach(string t in data){
					f.WriteLine(t);
				}
				f.Close();
				return true;
			}catch{
				return false;
			}
		}
		public static bool binary_load(string name, out byte [] image)
		{
			image = null;
			try{
				Stream f = File.OpenRead(name);
				if(f.Length >= 0x100000){
					return false;
				}
				image = new byte [f.Length];
				f.Read(image, 0, (int) f.Length);
				f.Close();
				return true;
			}catch {
				return false;
			}
		}
		public static bool binary_save(string name, byte [] image)
		{
			try{
				File.WriteAllBytes(name, image);
				return true;
			}catch {
				return false;
			}
		}
		public static byte [] memory_new_fill(int size, byte data)
		{
			byte [] ret = new byte[size];
			for(int i = 0; i < size; i++){
				ret[i] = data;
			}
			return ret;
		}
	}
}
