using System;
using System.Diagnostics;
using System.Collections.Generic;

namespace hardware{
	class m6502{
		public const int POINTER_SIZE = 2;
		enum Opcode : byte{
			JSR_ABS = 0x20,
			STORE_A_ABS = 0x8d, STORE_X_ABS = 0x8e, STORE_Y_ABS = 0x8c
		}
		public static void word_add(List<byte> list, int data)
		{
			list.Add((byte) (data & 0xff));
			list.Add((byte) ((data>> 8) & 0xff));
		}
		public static void word_set(List<byte>manage, int offset, int address)
		{
			manage[offset + 0] = (byte) (address & 0xff);
			manage[offset + 1] = (byte) ((address >> 8) & 0xff);
		}
		public static void word_set(uint word, byte [] data, ref int offset)
		{
			data[offset++] = (byte) (word & 0xff);
			data[offset++] = (byte) ((word >> 8) & 0xff);
		}
		public static int word_dequeue(Queue<byte> bytedata)
		{
			int ret = bytedata.Dequeue();
			ret |= bytedata.Dequeue() << 8;
			return ret;
		}
		public static int word_get(byte [] data, ref int offset)
		{
			int ret = data[offset++];
			ret |= data[offset++] << 8;
			return ret;
		}
		public static void jsr_set(uint word, ref byte [] data, ref int offset)
		{
			data[offset++] = (byte) Opcode.JSR_ABS;
			/*this.*/ word_set(word, data, ref offset);
		}
		//mdc5.bios class を作り直して移転させる予定
		const uint MDC5_MIRROR_SET_A = 0xf400;
		const uint MDC5_MIRROR_SET_X = 0xf409;
		const uint MDC5_MIRROR_SET_Y = 0xf40C;
		public static bool patch_store(byte opcode, out uint jsr, out string name)
		{
			jsr = 0;
			name = "";
			switch((Opcode) opcode){
			case Opcode.STORE_A_ABS:
				jsr = MDC5_MIRROR_SET_A;
				name = "mdc5_mirror_set_a";
				break;
			case Opcode.STORE_X_ABS:
				jsr = MDC5_MIRROR_SET_X;
				name = "mdc5_mirror_set_x";
				break;
			case Opcode.STORE_Y_ABS:
				jsr = MDC5_MIRROR_SET_Y;
				name = "mdc5_mirror_set_y";
				break;
			}
			return jsr != 0;
		}
	}
	class rp2c33{
		const int CONTROL_REGISTER = 0x4025;
		public static bool control(byte [] data, int offset)
		{
			return m6502.word_get(data, ref offset) == CONTROL_REGISTER;
		}
	}
	class mmc5{
		public const int PAGESIZE = 0x2000;
		const int PAGESIZE_MASK = PAGESIZE - 1;
		const int PAGESHIFT = 8 + 5;
		public const int PAGE_ROM = 0x80, PAGE_RAM = 0;
		const int PAGENUM_MASK = PAGE_ROM - 1;
		public const int PAGE_W_RAM_0 = 0; //から3まで.battery backup
		public const int PAGE_W_RAM_1 = 4; //から7まで
		const int MBIT = 0x20000;
		public const int OFFSET_SIZE = 3;
		public const int CPU_ROMSIZE_MAX = 8 * MBIT;
		public const int PPU_ROMSIZE_MAX = 8 * MBIT;
		public static readonly int [] CPU_ROMSIZE = {
			0x4000, 0x8000, 0x10000,
			1 * MBIT, 2 * MBIT, 4 * MBIT, 8 * MBIT
		};
		public static readonly int [] PPU_ROMSIZE = {
			0, 0x2000, 0x4000, 0x8000, 0x10000,
			1 * MBIT, 2 * MBIT, 4 * MBIT, 8 * MBIT
		};
		public static readonly int [] CPU_RAMSIZE = {
			0, 
			0x2000, //6264x1:[ST]NROM, TSROM, [STE][KL]ROM
			0x4000*2, //6264x2:SOROM, ETROM
			0x8000, //62256x1: SXROM, EWROM
			//0x8000 + 0x2000, //ETROM for MDC5 personal NES ヘッダ規定外なのでエミュレータ上では debug を使う
			0x8000*2 //62256x2: ETROM for MDC5 debug
		};
		public enum cpu_bank_mode {
			cpu_8888 = 0, cpu_88cc, cpu_88ce, cpu_8ace
		};
		public enum ppu_bank_mode {
			ppu_2000x1 = 0, ppu_1000x2, ppu_0800x4, ppu_0400x8
		};
		public const int MIRROR_H = 0x50;
		public const int MIRROR_V = 0x44;
		
		public static void offset_add(int data, List<byte> list)
		{
			m6502.word_add(list, data & PAGESIZE_MASK);
			int mdcpage = data >> PAGESHIFT;
			mdcpage &= PAGENUM_MASK;
			mdcpage |= PAGE_ROM;
			list.Add((byte) mdcpage);
		}
		static void offset_set(int offset, int data, int memory, List<byte> list)
		{
			m6502.word_set(list, offset, data & PAGESIZE_MASK);
			offset += m6502.POINTER_SIZE;
			int c = data >> PAGESHIFT;
			c &= PAGENUM_MASK;
			c |= memory;
			list[offset] = (byte) c;
		}
		public static void rom_offset_set(int offset, int data, List<byte> list)
		{
			offset_set(offset, data, PAGE_ROM, list);
		}
		static void offset_add(int data, int memory, List<byte> list)
		{
			m6502.word_add(list, data & PAGESIZE_MASK);
			int c = data >> PAGESHIFT;
			c &= PAGENUM_MASK;
			c |= memory;
			list.Add((byte) c);
		}
		public static void ram_offset_add(int data, List<byte> list)
		{
			offset_add(data, PAGE_RAM, list);
		}
		public static void rom_offset_add(int data, List<byte> list)
		{
			offset_add(data, PAGE_ROM, list);
		}
		static int offset_decode(int page, int offset, int mdc)
		{
			int abs = offset & PAGESIZE_MASK;
			abs += (page & PAGENUM_MASK) * PAGESIZE;
			return abs - mdc;
		}
		public static int offset_dequeue(Queue<byte> t, int mdc)
		{
			int offset = m6502.word_dequeue(t);
			return offset_decode(t.Dequeue(), offset, mdc);
		}
	}
}
