using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Collections.Generic;
using System.Security.Cryptography;

namespace Interface //interface は予約語で使用できない
{
	class ImageHash
	{
		public const int SIZE = 160/8;
		SHA1Managed m_manage;
		byte [] m_hash;
		bool m_computed;
		
		public byte [] Hash
		{
			get{ 
				Debug.Assert(m_computed == true);
				return m_hash;
			}
		}
		public ImageHash(byte [] d)
		{
			m_computed = true;
			Debug.Assert(d.Length == SIZE);
			m_hash = d;
		}
		public ImageHash()
		{
			m_hash = new byte [SIZE];
			m_computed = false;
			m_manage = new SHA1Managed();
		}
		public override int GetHashCode()
		{
			if(m_computed == false){
				return 0;
			}
			int ret = 0;
			for(int i = 0; i < SIZE/4; i++){
				for(int j = 0; j < 4; j++){
					int offset = i *4 + j;
					int shift = j *8;
					ret ^= m_hash[offset] << shift;
				}
			}
			return ret;
		}
/*		public override bool Equals(object o)
		{
			return o is ImageHash;
		}
		public static bool operator == (ImageHash r, ImageHash l)
		{
			return r.ToString() == r.ToString();
		}
		public static bool operator != (ImageHash r, ImageHash l)
		{
			return r.ToString() != r.ToString();
		}*/
		public void Transform(byte [] d)
		{
			Debug.Assert(m_computed == false);
			m_manage.TransformBlock(d, 0, d.Length, d, 0);
		}
		void final(byte []d, SHA1Managed manage, out byte [] hash, ref bool computed)
		{
			Debug.Assert(computed == false);
			m_manage.TransformFinalBlock(d, 0, d.Length);
			computed = true;
			hash = manage.Hash;
		}
		public void Final(byte []d)
		{
			final(d, m_manage, out m_hash, ref m_computed);
		}
		public void Final()
		{
			byte [] d = new byte[0];
			final(d, m_manage, out m_hash, ref m_computed);
		}
		public override string ToString()
		{
			Debug.Assert(m_computed == true);
			string ret = "";
			foreach(byte t in m_hash){
				ret += String.Format("{0:x2}", t);
			}
			return ret;
		}
	}
	class LogArgument : EventArgs
	{
		public readonly string m_log;
		public LogArgument(string log)
		{
			m_log = log;
		}
	}
	class Logput
	{
		public delegate void LogAddHandler(object hoe, LogArgument argv);
		public LogAddHandler LogAdd;
		protected virtual void OnLogAdd(string s)
		{
			LogArgument argv = new LogArgument(s);
			if(LogAdd != null){
				LogAdd(this, argv);
			}
		}
		protected virtual void OnLogAdd(string [] s)
		{
			foreach(string t in s){
				this.OnLogAdd(t);
			}
		}
	}
	class Scanner : Logput
	{
		Dictionary<string, string> m_gameimage = new Dictionary<string, string>();
		const int DISKHASHVERSION = 2;
		bool search(string path, string safix, out string [] f)
		{
			f = null;
			try{
				DirectoryInfo di = new DirectoryInfo(path);
				FileInfo [] fi = di.GetFiles("*" + safix);
				f = new string[fi.Length];
				for(int i = 0; i < fi.Length; i++){
					f[i] = fi[i].FullName;
				}
				return true;
			}catch{
				return false;
			}
		}
		bool gameimage_list_get(
			string path, string imagetype, string filesafix,
			out string [] filelist
		){
			if(search(path, filesafix, out filelist) == false){
				OnLogAdd(imagetype + "image directory find error");
				return false;
			}
			if(filelist.Length == 0){
				OnLogAdd(imagetype + "image not found");
				return false;
			}
			return true;
		}
		bool diskimage_list_get(string path, out string [] filelist)
		{
			return gameimage_list_get(path, "disk", ".fds", out filelist);
		}
		bool romimage_list_get(string path, out string [] filelist)
		{
			return gameimage_list_get(path, "ROM", ".nes", out filelist);
		}
		public bool DiskimageFind(string path, bool hashlog)
		{
			string [] filelist;
			if(diskimage_list_get(path, out filelist) == false){
				return false;
			}
			foreach(string file in filelist){
				imagefile.Fds fds = new imagefile.Fds();
				if(fds.Load(file, DISKHASHVERSION) == false){
					string s = String.Format("{0}: filesystem error", file);
					OnLogAdd(s);
				}else{
					m_gameimage[fds.Hash] = file;
					if(hashlog == true){
						OnLogAdd(file);
						OnLogAdd(fds.HashListGet());
					}
				}
			}
			return true;
		}
		public bool RomimageFind(string path)
		{
			string [] filelist;
			if(romimage_list_get(path, out filelist) == false){
				return false;
			}
			foreach(string file in filelist){
				imagefile.Nes nes = new imagefile.Nes();
				if(nes.Load(file) == false){
					string s = String.Format("{0}: ROM image error", file);
					OnLogAdd(s);
				}else{
					m_gameimage[nes.Hash] = file;
				}
			}
			return true;
		}
		bool hashlist_out(string path_disk, string path_rom, out string[] log)
		{
			string [] filelist;
			List<string> hashlist = new List<string>();
			log = null;
			if(diskimage_list_get(path_disk, out filelist) == true){
				foreach(string file in filelist){
					imagefile.Fds fds = new imagefile.Fds();
					hashlist.Add(file);
					//linker 0.2.1 release 時に scriptversion 2 のみにする
					foreach(int hashversion in new int[] {1, 2}){
						hashlist.Add(String.Format("#scriptversion 0.0{0}", hashversion));
						if(fds.Load(file, hashversion) == true){
						foreach(string t in fds.HashListGet()){
							hashlist.Add(t);
						}
					}
				}
			}
			}
			if(romimage_list_get(path_rom, out filelist) == true){
				foreach(string file in filelist){
					imagefile.Nes nes = new imagefile.Nes();
					if(nes.Load(file) == true){
						hashlist.Add(file);
						foreach(string t in nes.HashListGet()){
							hashlist.Add(t);
						}
					}
				}
			}
			log = hashlist.ToArray();
			return true;
		}
		public bool HashlistFileOut(string path_disk, string path_rom, string filename)
		{
			string [] hashlist;
			if(hashlist_out(path_disk, path_rom, out hashlist) == false){
				return false;
			}
			Static.Utility.text_save(filename, hashlist);
			OnLogAdd(filename + " saved");
			return true;
		}
		public bool HashlistScreenOut(string path_disk, string path_rom)
		{
			string [] hashlist;
			if(hashlist_out(path_disk, path_rom, out hashlist) == false){
				return false;
			}
			OnLogAdd(hashlist);
			return true;
		}
		public bool FilesystemlistFileOut(string path_disk, string filename)
		{
			string [] filelist;
			List<string> fslist = new List<string>();
			if(diskimage_list_get(path_disk, out filelist) == true){
				foreach(string file in filelist){
					imagefile.Fds fds = new imagefile.Fds();
					if(fds.Load(file, DISKHASHVERSION) == true){
						fslist.Add(file);
						foreach(string t in fds.FilesystemShow()){
							fslist.Add(t);
						}
					}
				}
			}
			Static.Utility.text_save(filename, fslist.ToArray());
			OnLogAdd(filename + " saved");
			return true;
		}
		bool script_find(mdc5.Script s, string [] text, Dictionary<string, string> gameimage, List<mdc5.Script> list, out string log)
		{
			if(s.Load(text, out log) == true){
				if(gameimage.ContainsKey(s.Hash) == true){
					s.ImageFilename = m_gameimage[s.Hash];
					list.Add(s);
				}
				return true;
			}
			return false;
		}
		public bool ScriptFind(string path, out mdc5.Script [] script)
		{
			string [] filelist;
			script = null;
			if(search(path, ".mdc", out filelist) == false){
				return false;
			}
			List<mdc5.Script> list = new List<mdc5.Script>();
			foreach(string file in filelist){
				string error_rom, error_disk;
				string [] text;
				if(Static.Utility.text_load(file, out text) == false){
					OnLogAdd(file);
					OnLogAdd("scriptfile load error");
					continue;
				}
				if(script_find(new mdc5.DiskScript(), text, m_gameimage, list, out error_disk) == true){
					continue;
				}
				if(script_find(new mdc5.RomScript(), text, m_gameimage, list, out error_rom) == true){
					continue;
				}
				OnLogAdd(file);
				OnLogAdd(error_disk);
				OnLogAdd(error_rom);
			}
			script = list.ToArray();
			return true;
		}
		public bool FilenameToScript(string [] imagelist, string scriptpath, out mdc5.Script [] script)
		{
			script = null;
			foreach(string file in imagelist){
				imagefile.Fds fds = new imagefile.Fds();
				imagefile.Nes nes = new imagefile.Nes();
				if(fds.Load(file, DISKHASHVERSION) == true){
					m_gameimage[fds.Hash] = file;
				}else if(nes.Load(file) == true){
					m_gameimage[nes.Hash] = file;
				}else{
					string s = String.Format("{0}: file not found or filesystem error", file);
					OnLogAdd(s);
					return false;
				}
			}
			ScriptFind(scriptpath, out script); //ここのエラーのはじき方はあとでつける
			return script.Length != 0;
		}
	}
	public class Konfig //Config は予約語で使用できない
	{
		const string FILENAME = "mdc5linker.cfg";
		const string FIELD_PATH = "path.";
		const string FIELD_INTERFACE = "interface.";
		const string FIELD_WINDOW_POSITION = "window.position";
		const string FIELD_WINDOW_LOG_FONT = "window.log.font";
		const string FIELD_ROMNAMEAUTO = "romnameauto";
		const string FIELD_PATCHLOG = "patchlog";
		const string FIELD_OUTPUT = "output.";
		const string FIELD_LINK = "link.";
		const string FIELD_ROMCAPACITY = "romcapacity";
		static readonly string [] PATHMEMBER = {
			"romimage.in", "rompatch.in", "romimage.out", 
			"diskimage.in", "diskscript.in"
		};
		Dictionary<string, string> m_path = new Dictionary<string, string>();
		string m_window_log_font = "ＭＳ ゴシック";
		string m_filepath;
		bool m_output_nes = false, m_output_bin = false;
		bool m_romname_autoattach = false, m_patchlog_show = false;
		System.Drawing.Point m_window_position = new System.Drawing.Point(0, 0);
		int m_romcapacity = 0;
		//---- property ----
		public System.Drawing.Point WindowPostion
		{
			get {return m_window_position;}
			set {m_window_position = value;}
		}
		public string LogFont
		{
			get {return m_window_log_font;}
			set {m_window_log_font = value;}
		}
		public bool OutputBin
		{
			get {return m_output_bin;}
			set {m_output_bin = value;}
		}
		public bool OutputNes
		{
			get {return m_output_nes;}
			set {m_output_nes = value;}
		}
		public bool RomnameAutoattach{
			get {return m_romname_autoattach;}
			set {m_romname_autoattach = value;}
		}
		public bool PatchlogShow{
			get {return m_patchlog_show;}
			set {m_patchlog_show = value;}
		}
		public int RomCapacity{
			get {return m_romcapacity;}
			set {m_romcapacity = value;}
		}
		//---- method ----
		public string PathGet(string t)
		{
			Debug.Assert(m_path.ContainsKey(t));
			return m_path[t];
		}
		public Konfig(string program_path)
		{
			foreach(string t in PATHMEMBER){
				m_path[t] = program_path;
			}
		}
		public void FileLoad(string file_path)
		{
			string [] filedata;
			m_filepath = file_path;
			if(Static.Utility.text_load(file_path + "/" + FILENAME, out filedata) == false){
				return;
			}
			foreach(string t in filedata){
				GroupCollection g;
				if(Static.Utility.matching(t, @"^(path\.|interface\.|link\.)([a-z][a-z\.]+)\s=\s(\S+)$", out g) == false){
					continue;
				}
				switch(g[1].Value){
				case FIELD_PATH:
					if(m_path.ContainsKey(g[2].Value) == true){
						//末尾の / を弾く
						string key = g[2].Value;
						string path = g[3].Value;
						if(Static.Utility.matching(path, @"^(.+)[\/\\]$", out g) == true){
							path = g[1].Value;
						}
						m_path[key] = path;
					}
					break;
				case FIELD_INTERFACE:
					switch(g[2].Value){
					case FIELD_WINDOW_POSITION:
						if(Static.Utility.matching(g[3].Value, @"^(\d+),(\d+)$", out g) == true){
							m_window_position.X = Convert.ToInt32(g[1].Value, 10);
							m_window_position.Y = Convert.ToInt32(g[2].Value, 10);
						}
						break;
					case FIELD_WINDOW_LOG_FONT:
						m_window_log_font = g[3].Value;
						break;
					case FIELD_OUTPUT + "nes":
						m_output_nes = Convert.ToBoolean(g[3].Value);
						break;
					case FIELD_OUTPUT + "bin":
						m_output_bin = Convert.ToBoolean(g[3].Value);
						break;
					case FIELD_ROMNAMEAUTO:
						m_romname_autoattach = Convert.ToBoolean(g[3].Value);
						break;
					}
					break;
				case FIELD_LINK:
					switch(g[2].Value){
					case FIELD_ROMCAPACITY:
						if(Static.Utility.matching(g[3].Value, @"^0x([0-9A-Fa-f]+)$", out g) == true){
							int val = Convert.ToInt32(g[1].Value, 0x10);
							switch(val){
							case 0: case 0x10000: //auto, 27c512
							case 0x20000: case 0x40000: //1M, 2M
							case 0x80000: case 0x100000: //4M, 8M
								m_romcapacity = val;
								break;
							}
						}
						break;
					case FIELD_PATCHLOG:
						m_patchlog_show = Convert.ToBoolean(g[3].Value);
						break;
					}
					break;
				}
			}
		}
		public void FileSave(string file_path)
		{
			file_save(file_path);
		}
		public void FileSave()
		{
			file_save(m_filepath);
		}
		void file_save(string file_path)
		{
			string format = "{0}{1} = {2}";
			string t;
			System.IO.StreamWriter w = new System.IO.StreamWriter(file_path + "/" + FILENAME);
			foreach(string field in PATHMEMBER){
				//root directory がどうも正しく出ないみたい
				string path = m_path[field].Replace(@"\\", @"\");
				path = path.Replace(@"\", "/");
				t = String.Format(format, FIELD_PATH, field, path);
				w.WriteLine(t);
			}
			t = String.Format(format, FIELD_INTERFACE, FIELD_WINDOW_LOG_FONT, m_window_log_font);
			w.WriteLine(t);
			t = String.Format(
				"{0}{1} = {2:d},{3:d}",
				FIELD_INTERFACE, FIELD_WINDOW_POSITION, 
				m_window_position.X, m_window_position.Y
			);
			w.WriteLine(t);
			t = String.Format(
				"{0}{1}{2} = {3}", FIELD_INTERFACE, FIELD_OUTPUT, "bin", 
				m_output_bin
			);
			w.WriteLine(t);
			t = String.Format(
				"{0}{1}{2} = {3}", FIELD_INTERFACE, FIELD_OUTPUT, "nes", 
				m_output_nes
			);
			w.WriteLine(t);
			t = String.Format(
				"{0}{1} = {2}", FIELD_INTERFACE, FIELD_ROMNAMEAUTO, 
				m_romname_autoattach
			);
			w.WriteLine(t);
			t = String.Format(
				"{0}{1} = {2}", FIELD_INTERFACE, FIELD_PATCHLOG, 
				m_patchlog_show
			);
			w.WriteLine(t);
			t = String.Format(
				"{0}{1} = 0x{2:X}", FIELD_LINK, FIELD_ROMCAPACITY,
				m_romcapacity
			);
			w.WriteLine(t);
			w.Close();
		}
	}
}
