using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace mdc5linker
{
	class Candinate : ListBox
	{
		mdc5.Script [] m_script;
		public void ScriptSet(mdc5.Script [] script)
		{
			m_script = script;
			foreach(mdc5.Script t in m_script){
				this.Items.Add(t.GameName);
			}
		}
		public mdc5.Script ScriptGet(string field)
		{
			foreach(mdc5.Script t in m_script){
				if(t.GameName == field){
					return t;
				}
			}
			Debug.Assert(false);
			return null;
		}
		public mdc5.Script ScriptGet(int field)
		{
			return m_script[field];
		}
		public void Reset()
		{
			m_script = null;
			while(this.Items.Count != 0){
				this.Items.RemoveAt(0);
			}
		}
	}
	class SelectedImage : ListBox
	{
		List<mdc5.Script> m_script = new List<mdc5.Script>();
		
		public int Count
		{
			get {return m_script.Count;}
		}
		void swap(int dindex, ListBox display, ref List<mdc5.Script> list)
		{
			int oldindex = display.SelectedIndex;
			int newindex = display.SelectedIndex + dindex;
			if((newindex < 0) || (newindex >= display.Items.Count)){
				return;
			}
			//swap index
			{
				mdc5.Script temp = list[newindex];
				list[newindex] = list[oldindex];
				list[oldindex] = temp;
			}
			switch(dindex){
			case 1:
				display.Items.RemoveAt(oldindex);
				display.Items.Insert(newindex, list[newindex].GameName);
				break;
			case -1:
				display.Items.RemoveAt(newindex);
				display.Items.Insert(oldindex, list[oldindex].GameName);
				break;
			default:
				Debug.Assert(false);
				break;
			}
			display.SelectedIndex = oldindex;
		}

		//protected override void OnKeyDown(KeyEventArgs e)
		//list更新したら true を返す
		public bool ToKeyDown(KeyEventArgs e)
		{
			if(this.SelectedIndex == -1){
				return false;
			}
			int dindex = 0; //微分とかの d
			if((e.KeyData & Keys.Modifiers) == Keys.Shift){
				switch(e.KeyData & ~Keys.Modifiers){
				case Keys.Up:
					dindex = -1;
					break;
				case Keys.Down:
					dindex = 1;
					break;
				}
			}else if(e.KeyData == Keys.Delete){
				m_script.RemoveAt(this.SelectedIndex);
				this.Items.RemoveAt(this.SelectedIndex);
				return true;
			}
			if(dindex != 0){
				swap(dindex, this, ref m_script);
				return true;
			}
			return false;
		}
		public void ScriptAdd(mdc5.Script s)
		{
			m_script.Add(s);
			this.Items.Add(s.GameName);
		}
		
		public mdc5.Script []ScriptGet()
		{
			return m_script.ToArray();
		}
		public void Reset()
		{
			m_script = new List<mdc5.Script>();
			while(this.Items.Count != 0){
				this.Items.RemoveAt(0);
			}
		}
		public string OutputNameGet()
		{
			if(m_script.Count == 0){
				return "";
			}
			return ConsoleLinker.AutoFilenameGet(m_script.ToArray());
		}
	}
}
