using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace mdc5linker
{
	class GuiLogger: TextBox
	{
		public void Subscribe(Interface.Logput s)
		{
			s.LogAdd += new Interface.Scanner.LogAddHandler(Append);
		}

		public void Append(string newlog)
		{
			this.Text += "\r\n" + newlog;
			this.Focus();
			this.Select(this.Text.Length, 0);
			this.ScrollToCaret();
		}

		public void Append(object t, Interface.LogArgument argv)
		{
			Append(argv.m_log);
		}

		public void Append(string [] newlog)
		{
			foreach(string t in newlog){
				Append(t);
			}
		}
	}
	class CuiLogger
	{
		public void Subscribe(Interface.Logput s)
		{
			s.LogAdd += new Interface.Scanner.LogAddHandler(Append);
		}

		public void Append(string newlog)
		{
			Console.WriteLine("{0}", newlog);
		}

		public void Append(object t, Interface.LogArgument argv)
		{
			Append(argv.m_log);
		}

		public void Append(string [] newlog)
		{
			foreach(string t in newlog){
				Append(t);
			}
		}
	}
}
