using System;
using System.Diagnostics;
using System.Collections.Generic;

namespace Archiver{
	class SameData{
		int m_count = 1;
		readonly int m_offset;
		public int Count{
			get { return m_count; }
		}
		public int Offset{
			get { return m_offset; }
		}
		public SameData(int offset)
		{
			m_offset = offset;
		}
		public void Increment()
		{
			m_count += 1;
		}
	}

/*
BPE
m_buffer_size をデータの1単位として、圧縮する。
Row:     0 1 2 3 2 2 4 5
BPE:     0 1 2 3 2 2 4 5
ヘッダに下記の情報を入れる。
header spec: 16bit little endian
bit15: compressed 0:row 1:bpe compressed
bit0-14: datasize

Duplicate + BPE
BPE ヘッダを拡張する。
bit15: compressed 0:row 1:bpe compressed
bit14: original data 1:no 0:yes
bit0-13: datasize

original data is ...
yes: bpedata[datasize] bpe 圧縮データを入れる
no : bpedata[3] bpedata offset を入れて参照する
*/
	class DuplicateMap{
		bool m_original = true;
		public bool Original{
			get {return m_original;}
			set {m_original = value;}
		}
		public int Block{
			get; set;
		}
	}
	class Duplicate{
		readonly int m_buffer_size;
		Dictionary<string, SameData> m_samedata = new Dictionary<string, SameData>();
		public Duplicate(int bufsize)
		{
			m_buffer_size = bufsize;
		}
		static public string hash_get(byte [] data)
		{
			Interface.ImageHash ih = new Interface.ImageHash();
			ih.Final(data);
			return ih.ToString();
		}
		/* return: original data?*/
		bool buffer_regist(Dictionary<string, SameData> samedata, byte [] data, int offset, int buffer_size)
		{
			string hash = hash_get(data);
			if(samedata.ContainsKey(hash) == false){
				SameData s = new SameData(offset);
				samedata[hash] = s;
				return true;
			}else{
				samedata[hash].Increment();
				return false;
			}
		}
		int buffer_ask(Dictionary<string, SameData> samedata, byte [] data)
		{
			string hash = hash_get(data);
			Debug.Assert(samedata.ContainsKey(hash) == true);
			return samedata[hash].Offset;
		}
		public bool MapMake(byte [] rowdata, out DuplicateMap [] map)
		{
			if((rowdata.Length % m_buffer_size) != 0){
				map = null;
				return false;
			}
			int mapsize = rowdata.Length / m_buffer_size;
			//rommake
			map = new DuplicateMap[mapsize];
			byte [][] page = new byte[mapsize][];
			for(int i = 0, j = 0; i < rowdata.Length; i += m_buffer_size, j++)
			{
				page[j] = new byte [m_buffer_size];
				Buffer.BlockCopy(rowdata, i, page[j], 0, m_buffer_size);
				map[j] = new DuplicateMap();
				map[j].Original = buffer_regist(m_samedata, page[j], i, m_buffer_size);
			}
			//mapmake
			for(int i = 0; i < mapsize; i++){
				map[i].Block = buffer_ask(m_samedata, page[i]) / m_buffer_size;
			}
			Debug.Assert(map.Length == mapsize);
			return true;
		}
	}
}
