using System;
using System.Text;
using System.Diagnostics;
using System.Collections.Generic;

namespace imagefile{
	public class SaveArgument{
		public string Name{
			get; set;
		}
		public string Side{
			get; set;
		}
		public int Length{
			get; set;
		}
		public int ImageOffset{
			get; set;
		}
		public int RamOffset{
			get; set;
		}
	}
	abstract class GameImage{
		protected Interface.ImageHash m_hash;
		protected string m_name = "", m_code = "", m_version = "";
		readonly mdc5.Script.imagetype m_type;
		public enum patchresult{
			OK, AREA_TOOMUCH, AREA_NOTFOUND
		};
		//---- property ----
		public string Hash{
			get{return m_hash.ToString();}
		}
		public string Name{
			get {return m_name;}
		}
		public string Code{
			get {return m_code;}
		}
		public mdc5.Script.imagetype Type{
			get {return m_type;}
		}
		//---- method ----
		public GameImage(mdc5.Script.imagetype type)
		{
			m_type = type;
		}
		abstract public bool Load(mdc5.Script s);
		abstract public bool Load(string filename);
		abstract public void HashListAdd(List<string> list);
		abstract public patchresult PatchManual(RomRecoard.MotorolaSRecoard r, out string log);
		abstract public int RawByte();
		abstract public bool SavedataSearch(imagestream.W_Ram workram);
		abstract public bool StreamMake(imagestream.W_Ram workram, out int blocksize, out int streamsize);
		virtual public void RomBlockAllocate(ref int offset)
		{
		}
		abstract public void RomStreamAllocate(ref int offset);
		abstract protected void manage_make(imagestream.W_Ram workram, List<byte>manage);
		virtual public bool RomBlockWrite(ref int offset, byte [] rom)
		{
			//disk に block write はない
			return true;
		}
		abstract public bool RomStreamWrite(ref int offset, byte [] rom);
		//linker.cs GameImage.script_load で disk と rom を統合するために作成.
		//ROM の場合は呼び出されないので assert が発動する
		virtual public patchresult PatchAuto(out string [] log)
		{
			Debug.Assert(false);
			log = null;
			return patchresult.AREA_NOTFOUND;
		}

		static public void PatchMemory(RomRecoard.MotorolaSRecoard r, ref byte [] memory, string logformat, ref string log)
		{
			uint offset = r.Address - r.TargetOffset;
			string olddata = "", newdata = "";
			for(uint i = 0; i < r.Data.Length; i++){
				olddata += String.Format("${0:x2} ", memory[offset + i]);
				newdata += String.Format("${0:x2} ", r.Data[i]);
				memory[offset + i] = r.Data[i];
			}
			log += String.Format(logformat + "/${1:x4}: {2}->{3}", offset, r.Address, olddata, newdata);
		}
		void bgname_set(string name, int cpu_offset, imagestream.BgString bg, List<byte>manage, int manage_offset)
		{
			hardware.m6502.word_set(manage, manage_offset, cpu_offset + manage.Count);
			bg.StringSet(name, manage);
		}
		public byte[] ManageMake(imagestream.W_Ram workram, int offset, imagestream.BgString bg)
		{
			List<byte>manage = new List<byte>();
			//0 type
			manage.Add((byte) m_type);
			//1 *name
			//3 *code
			//5 *version
			for(int i = 0; i< 3 * hardware.m6502.POINTER_SIZE; i++){
				manage.Add(0x00); //あとで
			}
			manage_make(workram, manage);
			//name pointer set
			bgname_set(m_name, offset, bg, manage, 1);
			bgname_set(m_code, offset, bg, manage, 3);
			//bgname_set(m_version, offset, bg, manage, 5);
			return manage.ToArray();
		}
	}
}
