using System;
using System.Diagnostics;
using System.Collections.Generic;

namespace Archiver{
	class SameData{
		int m_count = 1;
		readonly int m_offset;
		public int Count{
			get { return m_count; }
		}
		public int Offset{
			get { return m_offset; }
		}
		public SameData(int offset)
		{
			m_offset = offset;
		}
		public void Increment()
		{
			m_count += 1;
		}
	}

/*
Duplicate Archiving
m_buffer_size をデータの1単位として、重複するものはデータに含めない。

Row:     0 1 2 3 2 2 4 5
Dup map: 0 1 2 3 2 2 4 5
Dup data:0 1 2 3 4 5

BPE
m_buffer_size をデータの1単位として、圧縮する。
Row:     0 1 2 3 2 2 4 5
BPE:     0 1 2 3 2 2 4 5
ヘッダに下記の情報を入れる。
header spec: 16bit little endian
bit15: compressed 0:row 1:bpe compressed
bit0-14: datasize

Duplicate + BPE
BPE ヘッダを拡張する。
bit15: compressed 0:row 1:bpe compressed
bit14: original data 1:no 0:yes
bit0-13: datasize

original data is ...
yes: bpedata[datasize] bpe 圧縮データを入れる
no : bpedata[3] bpedata offset を入れて参照する
*/
	class DuplicateMap{
		bool m_original = true;
		int m_offset = -1;
		public bool Original{
			get {return m_original;}
			set {m_original = value;}
		}
		public int Offset{
			get {return m_offset;}
			set {m_offset = value;}
		}
	}
	class Duplicate{
		readonly int m_buffer_size;
		Dictionary<string, SameData> m_samedata = new Dictionary<string, SameData>();
		public Duplicate(int bufsize)
		{
			m_buffer_size = bufsize;
		}
		int fetch_little_endian(byte [] fetchdata, int length, ref int offset)
		{
			int ret = 0;
			Debug.Assert(length == 4);
			for(int i = 0; i < length; i++){
				ret |= fetchdata[offset++] << (i * 8);
			}
			return ret;
		}
		virtual public bool Decode(byte [] encodedata, out byte [] rowdata)
		{
			int offset = 0;
			//---- 0: buffer size
			int buffer_size = fetch_little_endian(encodedata, 4, ref offset);
			if(buffer_size != m_buffer_size){
				rowdata = null;
				return false;
			}
			//---- 4: map count
			int mapcount = fetch_little_endian(encodedata, 4, ref offset);
			//---- 8-: map data[map count]
			int [] map = new int [mapcount];
			for(int i = 0; i < mapcount; i++){
				map[i] = fetch_little_endian(encodedata, 4, ref offset);
			}
			//buffer size check
			int blocksize = encodedata.Length - offset;
			int rowsize = mapcount * buffer_size;
			//block data get
			byte [] block = new byte[blocksize];
			Buffer.BlockCopy(encodedata, offset, block, 0, blocksize);
			offset += blocksize;
			Debug.Assert(offset == encodedata.Length); //自明だな..
			//encode
			return Decode(block, map, out rowdata);
		}
		public bool Decode(byte [] block, int [] map, out byte [] rowdata)
		{
			List<byte> row = new List<byte>();
			foreach(int offset in map){
				for(int i = 0; i < m_buffer_size; i++){
					row.Add(block[offset + i]);
				}
			}
			rowdata = row.ToArray();
			return true;
		}
		static public string hash_get(byte [] data)
		{
			Interface.ImageHash ih = new Interface.ImageHash();
			ih.Final(data);
			return ih.ToString();
		}
		/* return: original data?*/
		bool buffer_regist(Dictionary<string, SameData> samedata, byte [] data, int offset, int buffer_size)
		{
			string hash = hash_get(data);
			if(samedata.ContainsKey(hash) == false){
				SameData s = new SameData(offset);
				samedata[hash] = s;
				return true;
			}else{
				samedata[hash].Increment();
				return false;
			}
		}
		int buffer_ask(Dictionary<string, SameData> samedata, byte [] data)
		{
			string hash = hash_get(data);
			Debug.Assert(samedata.ContainsKey(hash) == true);
			return samedata[hash].Offset;
		}
		void pack_little_endian(int writedata, int length, ref int offset, ref byte [] packdata)
		{
			Debug.Assert(length == 4);
			for(int i = 0; i < length; i++){
				packdata[offset++] = (byte) ((writedata >> (i * 8)) & 0xff);
			}
		}
		public bool Encode(byte [] rowdata, out byte [] encodedata)
		{
			byte [] block;
			DuplicateMap [] map;
			if(Encode(rowdata, out block, out map) == false){
				encodedata = null;
				return false;
			}
			encodedata = new byte [(2 + map.Length) * 4 + block.Length];
			int offset = 0;
			pack_little_endian(m_buffer_size, 4, ref offset, ref encodedata);
			pack_little_endian(map.Length, 4, ref offset, ref encodedata);
			foreach(DuplicateMap t in map){
				pack_little_endian(t.Offset, 4, ref offset, ref encodedata);
			}
			Buffer.BlockCopy(block, 0, encodedata, offset, block.Length);
			offset += block.Length;
			Debug.Assert(offset == encodedata.Length);
			return true;
		}
		public bool Encode(byte [] rowdata, out byte [] encodedata, out DuplicateMap [] map)
		{
			if((rowdata.Length % m_buffer_size) != 0){
				encodedata = null;
				map = null;
				return false;
			}
			int mapsize = rowdata.Length / m_buffer_size;
			//rommake
			List<byte> rom = new List<byte>();
			map = new DuplicateMap[mapsize];
			byte [][] page = new byte[mapsize][];
			for(int i = 0, j = 0; i < rowdata.Length; i += m_buffer_size, j++)
			{
				page[j] = new byte [m_buffer_size];
				Buffer.BlockCopy(rowdata, i, page[j], 0, m_buffer_size);
				map[j] = new DuplicateMap();
				map[j].Original = buffer_regist(m_samedata, page[j], rom.Count, m_buffer_size);
				if(map[j].Original == true){
					foreach(byte t in page[j]){
						rom.Add(t);
					}
				}
			}
			encodedata = rom.ToArray();
			//mapmake
			for(int i = 0; i < mapsize; i++){
				map[i].Offset = buffer_ask(m_samedata, page[i]);
			}
			Debug.Assert(map.Length == mapsize);
			return true;
		}
	}
}
