/*
 *  Orignal X509TrustManager
 *  User can connect to untrusted SMTP server aka OreOre server.
 */
package org.jent.checksmtp.ssl;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/**
 * Baseed on sample code from http://java.sun.com/javase/ja/6/docs/ja/technotes/guides/security/jsse/JSSERefGuide.html#X509TrustManager
 *
 * @author takuya-o@users.sourceforge.jp "Takuya Ono"
 */
public class RespondingX509TrustManager implements X509TrustManager {
  //Conform status.

  private final int RESULT_UNKNOWN = 0;
  private final int RESULT_YES = 1;
  private final int RESULT_NO = 2;
  private int result = RESULT_UNKNOWN;
  /*
   * The default PKIX X509TrustManager9.  We'll delegate
   * decisions to it, and fall back to the logic in this class if the
   * default X509TrustManager doesn't trust it.
   */
  X509TrustManager pkixTrustManager;

  public RespondingX509TrustManager() throws Exception {
    // create a "default" JSSE X509TrustManager.
    //KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
    TrustManagerFactory tmf =
            TrustManagerFactory.getInstance("PKIX");
    tmf.init((KeyStore) null);  //Default KeyStore by null argument.

    TrustManager tms[] = tmf.getTrustManagers();

    /*
     * Iterate over the returned trustmanagers, look
     * for an instance of X509TrustManager.  If found,
     * use that as our "default" trust manager.
     */
    for (int i = 0; i < tms.length; i++) {
      if (tms[i] instanceof X509TrustManager) {
        pkixTrustManager = (X509TrustManager) tms[i];
        //sun.security.ssl.X509TrustManagerImpl();
        return;
      }
    }

    /*
     * Find some other way to initialize, or else we have to fail the
     * constructor.
     */
    throw new Exception("Couldn't initialize");
  }

  /*
   * Delegate to the default trust manager.
   */
  public void checkClientTrusted(X509Certificate[] chain, String authType)
          throws CertificateException {
    try {
      pkixTrustManager.checkClientTrusted(chain, authType);
    } catch (CertificateException excep) {
      // do any special handling here, or rethrow exception.
      throw excep; // Same as X509TrustManager
    }
  }

  /*
   * Delegate to the default trust manager.
   */
  public void checkServerTrusted(X509Certificate[] chain, String authType)
          throws CertificateException {

    //List chain from
    //http://code.google.com/p/openmeetings/source/browse/trunk/singlewebapp/src/app/org/openmeetings/app/sip/xmlrpc/EasyX509TrustManager.java?r=3132
    if (chain != null) {
      System.out.println("Server certificate chain:");
      for (int i = 0; i < chain.length; i++) {
        System.out.println("X509Certificate[" + i + "]=" + chain[i].getSubjectDN());
      }
    }
    try {
      pkixTrustManager.checkServerTrusted(chain, authType);
    } catch (CertificateException excep) {
      /*
       * Possibly pop up a dialog box asking whether to trust the
       * cert chain.
       */
      //TODO: Pop up waring dialog.
      result = RESULT_UNKNOWN;
      new WarningServerTrustFrame(this, chain);
      while (result == RESULT_UNKNOWN) {
        try {
          synchronized (this) {
            wait();
          }
        } catch (InterruptedException e) {
          System.err.println("Waring dialog wait interrupted");
          e.printStackTrace();
        }
      }
      if ( result == RESULT_YES) {
        //TODO: 何回もサーバの信頼を確認しないようにする。
        System.err.println("Connecting untrusted SMTP server." + chain[0].getSubjectDN());
      } else {
        throw excep;
      }
    }
  }

  /*
   * Merely pass this through.
   */
  public X509Certificate[] getAcceptedIssuers() {
    return pkixTrustManager.getAcceptedIssuers();
  }

  public void pushYes() {
    result = RESULT_YES;
    notifyResult();
  }

  public void pushNo() {
    result = RESULT_NO;
    notifyResult();
  }

  private synchronized void notifyResult() {
      notify();
  }
}
