package org.jent.checksmtp;

import java.io.UnsupportedEncodingException;

import java.util.Properties;
import java.util.regex.Pattern;

import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;


public class LDAPSearch {
  static private InitialDirContext ctx = null;
  static private String lastProviderUrl = null;
  static private MessageDialogUI initErrorDialog = null;
  
  private LDAPSearch() {
  }

  static synchronized private void init() {
    if ( ApplicationProperties.getLdap() ) {
      //not initialized ctx or LDAP Provider URL was changed.
      if ( ctx==null 
      || (!lastProviderUrl.equals(ApplicationProperties.getLdapProviderURL())) ) {
        try {
          if ( ctx != null ) { close(); }
          System.out.println("init  LDAP connection.");
          //InitialDirContext
          lastProviderUrl = ApplicationProperties.getLdapProviderURL();
          Properties env = new Properties();
          env.setProperty(Context.INITIAL_CONTEXT_FACTORY,
                          "com.sun.jndi.ldap.LdapCtxFactory"); // NOI18N
          env.put(Context.PROVIDER_URL, lastProviderUrl);
    
          ctx = new InitialDirContext(env);
        } catch (NamingException e) {
          String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("LDAPSearch.error.LDAPSearch_init_error.");
          System.err.println(errorMessage);
          lastProviderUrl = null;
          e.printStackTrace();
          displayErrorDialog(errorMessage, e);
        }
      }
    }
  }

  /**
   * Display error dialog and devide too many LDAP error dialogs.
   */
  private static void displayErrorDialog(final String errorMessage, final Exception e) {
    if ( initErrorDialog == null || !initErrorDialog.isVisible() ) {
      //Not displaying on screen.
      initErrorDialog = new MessageDialogUI(errorMessage, e, 
              MessageDialogUI.ERROR_MODE);
    }
  }
  
  /**
   * LDAP connection close.
   * <P>LDAP connection open is automatical.</P>
   * <P>If you hope aboid LDAP Server cconnection timeout close, you call close().</P>
   */
  public static synchronized void close()
  {
    try
    {
      if (ctx != null)
      {
        System.out.println("close LDAP connection.");
        ctx.close();
        ctx = null;
      }
    }
    catch (NamingException e)
    {
      System.err.println("Ignore LDAPSearch close error."); 
      //e.printStackTrace();
    }
  }
  
  public static String search(String mail) {
    String ans = ""; // NOI18N

    if (!ApplicationProperties.getLdap()) {
        return ans;
    }
    if ( ctx==null
      || ( (lastProviderUrl != null) 
          && (!lastProviderUrl.equals(ApplicationProperties.getLdapProviderURL()))
      )
    ) {
         init();
    }
    
    Pattern pattern = Pattern.compile("[ \t]+"); // NOI18N Attributes separate by space.
    String[] attrNames = pattern.split(ApplicationProperties.getLdapAttributes());

    System.err.println("LDAP Serarch= " + mail + " " + attrNames[0]);

    SearchControls ctrl = new SearchControls();
    ctrl.setSearchScope(ctrl.SUBTREE_SCOPE);
    ctrl.setTimeLimit(5000); //5sec
    ctrl.setCountLimit(3);  //I want to get only 1 recodes.
    ctrl.setReturningAttributes(attrNames);

    try {
      NamingEnumeration mailList = ctx.search(ApplicationProperties.getLdapRoot(),
                                          "(mail=" + mail + ")", ctrl); // NOI18N

      while ( mailList.hasMore() ) {
        SearchResult sr = (SearchResult) mailList.next();

        //System.out.println("SearchResult=" + sr);
        for (int i = 0; i < attrNames.length; i++) {
          Attribute attr = sr.getAttributes().get(attrNames[i]);
          String str;

          if (attr == null) {
              str = ""; // NOI18N
          } else {
              str = (String) attr.get();
          }
          if (str == null) { str = "";  } // NOI18N

          if (ApplicationProperties.getLdapIsSjis()) {
              str = new String(str.getBytes("ISO-8859-1"), "UTF-8"); // NOI18N
          }
          if (i != 0) { ans += " "; } // NOI18N
          ans += str;
        }
        System.err.println("ANS=" + ans); 
      }
      mailList.close();
    } catch (TimeLimitExceededException tlEx) {
      System.out.println("LDAP Search Time Limit.");
      //IGNORE Exception
    } catch (NameNotFoundException nnfEx) {
      System.out.println("LDAP Search Name Not Found.");
      //IGNORE Exception
    } catch (NamingException e) {
      String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("LDAPSearch.error.LDAP_Search_Error.");
      System.err.println(errorMessage);
      e.printStackTrace();
      //ctx reflesh
      close();
      displayErrorDialog(errorMessage, e);
    } catch (UnsupportedEncodingException ueEx) { //Unexpected.
      UnsupportedEncodingException e = ueEx;
      System.err.println("LDAP SJIS Error.");
      e.printStackTrace();
    } catch (NullPointerException npEx) { //for failsafe.
      String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("LDAPSearch.error.LDAP_Unexpected_Error.");
      NullPointerException e = npEx;
      System.err.println(errorMessage);
      e.printStackTrace();
      displayErrorDialog(errorMessage, e);
    } 

    return ans;
  }
}
