/*
 * ApplicationUI.java
 *
 * Created on 2007/07/21, 22:37
 */

package org.jent.checksmtp;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

/**
 *
 * @author  Takuya Ono <takuya-o@users.sourceforge.jp>
 */
public class ApplicationUI extends javax.swing.JFrame {
  
  /** Creates new form ApplicationUI */
  public ApplicationUI() {
    initComponents();
    
    //set Focus
    jButtonOK.requestFocusInWindow();
    //getRootPane().setDefaultButton(jButtonOK);
    
    resetDisplay();
  }
  
  private void resetDisplay() {
    //reset display data from ApplicationProperties.
    jTextFieldReceiverPort.setText(Integer.toString(ApplicationProperties.getSmtpPort()));
    jTextFieldServerHost.setText(ApplicationProperties.getSmtpServerHost());
    jTextFieldServerPort.setText(Integer.toString(ApplicationProperties.getSmtpServerPort()));
    jCheckBoxServerSSL.setSelected(ApplicationProperties.getSmtpServerSSL());
    jCheckBoxEnableRemoteConnect.setSelected(ApplicationProperties.getSmtpEnebleRemoteConnect());
    jTextFieldConfirmTimeout.setText(Integer.toString(ApplicationProperties.getConfirmTimeout()));
    
    jCheckBoxLdap.setSelected(ApplicationProperties.getLdap());
    jTextFieldProviderUrl.setText(ApplicationProperties.getLdapProviderURL());
    jTextFieldBaseDn.setText(ApplicationProperties.getLdapRoot());
    jTextFieldAttribute.setText(ApplicationProperties.getLdapAttributes());
    jCheckBoxIsSjis.setSelected(ApplicationProperties.getLdapIsSjis());
    
  }
  
  static private MessageDialogUI portNumberOutOfRangeErrorDialog = null;
  class PortNumberInputVerifier extends  InputVerifier {
    public boolean verify(JComponent jComponent) {
      JTextField jTextField = (JTextField) jComponent;
      boolean ret = true;
      String input = jTextField.getText();
      
      try {
        int port = Integer.parseInt(input);
        checkPortRange(port);
      } catch (Exception e) {
        ret = false;
      }
      
      if ( !ret ) {
        jTextField.setBackground(Color.PINK);
        if ( portNumberOutOfRangeErrorDialog == null ) {
          portNumberOutOfRangeErrorDialog =
                  new MessageDialogUI(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.Port_number_is_integer_from_1_to_65535."),
                  null, MessageDialogUI.WARNING_MODE);
        } else {
          portNumberOutOfRangeErrorDialog.setVisible(true);
        }
      } else {
        jTextField.setBackground(Color.WHITE);
      }
      
      return ret;
    }
  }
  
  static private MessageDialogUI timeoutRangeErrorDialog = null;
  class TimeoutNumberInputVerifier extends  InputVerifier {
    public boolean verify(JComponent jComponent) {
      JTextField jTextField = (JTextField) jComponent;
      boolean ret = true;
      String input = jTextField.getText();
      
      try {
        int timeout = Integer.parseInt(input);
        checkTimeoutRange(timeout);
      } catch (Exception e) {
        ret = false;
      }
      
      if ( !ret ) {
        jTextField.setBackground(Color.PINK);
        if ( timeoutRangeErrorDialog == null ) {
          timeoutRangeErrorDialog =
                  new MessageDialogUI(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.exception.Timeout_need_to_a_positive_number"),
                  null, MessageDialogUI.WARNING_MODE);
        } else {
          timeoutRangeErrorDialog.setVisible(true);
        }
      } else {
        jTextField.setBackground(Color.WHITE);
      }
      
      return ret;
    }
  }
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jTabbedPane = new javax.swing.JTabbedPane();
    jPanelMail = new javax.swing.JPanel();
    jLabel1 = new javax.swing.JLabel();
    jLabel2 = new javax.swing.JLabel();
    jLabel3 = new javax.swing.JLabel();
    jTextFieldReceiverPort = new javax.swing.JTextField();
    jTextFieldServerHost = new javax.swing.JTextField();
    jTextFieldServerPort = new javax.swing.JTextField();
    jCheckBoxEnableRemoteConnect = new javax.swing.JCheckBox();
    jLabel7 = new javax.swing.JLabel();
    jTextFieldConfirmTimeout = new javax.swing.JTextField();
    jCheckBoxServerSSL = new javax.swing.JCheckBox();
    jPanelLDAP = new javax.swing.JPanel();
    jCheckBoxLdap = new javax.swing.JCheckBox();
    jLabel4 = new javax.swing.JLabel();
    jLabel5 = new javax.swing.JLabel();
    jLabel6 = new javax.swing.JLabel();
    jTextFieldProviderUrl = new javax.swing.JTextField();
    jTextFieldBaseDn = new javax.swing.JTextField();
    jTextFieldAttribute = new javax.swing.JTextField();
    jCheckBoxIsSjis = new javax.swing.JCheckBox();
    jPanelAbout = new javax.swing.JPanel();
    jLabelProgramName = new javax.swing.JLabel();
    jLabelProgramVersion = new javax.swing.JLabel();
    jLabelSfURL = new javax.swing.JLabel();
    jButtonOK = new javax.swing.JButton();
    jButtonCancel = new javax.swing.JButton();
    jButtonQuit = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle"); // NOI18N
    setTitle(bundle.getString("ApplicationUI.title")); // NOI18N
    setIconImage(loadImageIcon());
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowDeiconified(java.awt.event.WindowEvent evt) {
        formWindowDeiconified(evt);
      }
      public void windowIconified(java.awt.event.WindowEvent evt) {
        formWindowIconified(evt);
      }
    });

    jLabel1.setText(bundle.getString("ApplicationUI.jLabel1.text")); // NOI18N

    jLabel2.setText(bundle.getString("ApplicationUI.jLabel2.text")); // NOI18N

    jLabel3.setText(bundle.getString("ApplicationUI.jLabel3.text")); // NOI18N

    jTextFieldReceiverPort.setText(bundle.getString("ApplicationUI.jTextFieldReceiverPort.text")); // NOI18N
    jTextFieldReceiverPort.setToolTipText(bundle.getString("ApplicationUI.jTextFieldReceiverPort.toolTipText")); // NOI18N
    jTextFieldReceiverPort.setInputVerifier(new PortNumberInputVerifier());
    jTextFieldReceiverPort.setMinimumSize(new java.awt.Dimension(44, 19));
    jTextFieldReceiverPort.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jTextFieldReceiverPortActionPerformed(evt);
      }
    });

    jTextFieldServerHost.setText(bundle.getString("ApplicationUI.jTextFieldServerHost.text")); // NOI18N
    jTextFieldServerHost.setToolTipText(bundle.getString("ApplicationUI.jTextFieldServerHost.toolTipText")); // NOI18N
    jTextFieldServerHost.setMinimumSize(new java.awt.Dimension(88, 19));

    jTextFieldServerPort.setText(bundle.getString("ApplicationUI.jTextFieldServerPort.text")); // NOI18N
    jTextFieldServerPort.setToolTipText(bundle.getString("ApplicationUI.jTextFieldServerPort.toolTipText")); // NOI18N
    jTextFieldServerPort.setInputVerifier(new PortNumberInputVerifier());
    jTextFieldServerPort.setMinimumSize(new java.awt.Dimension(44, 19));

    jCheckBoxEnableRemoteConnect.setText(bundle.getString("ApplicationUI.jCheckBoxEnableRemoteConnect.text")); // NOI18N
    jCheckBoxEnableRemoteConnect.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxEnableRemoteConnect.toolTipText")); // NOI18N
    jCheckBoxEnableRemoteConnect.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    jCheckBoxEnableRemoteConnect.setMargin(new java.awt.Insets(0, 0, 0, 0));

    jLabel7.setText(bundle.getString("ApplicationUI.jLabel7.text")); // NOI18N

    jTextFieldConfirmTimeout.setText(bundle.getString("ApplicationUI.jTextFieldConfirmTimeout.text")); // NOI18N
    jTextFieldConfirmTimeout.setToolTipText(bundle.getString("ApplicationUI.jTextFieldConfirmTimeout.toolTipText")); // NOI18N
    jTextFieldConfirmTimeout.setInputVerifier(new TimeoutNumberInputVerifier()
    );
    jTextFieldConfirmTimeout.setMinimumSize(new java.awt.Dimension(1, 19));

    jCheckBoxServerSSL.setText(bundle.getString("ApplicationUI.jCheckBoxServerSSL.text")); // NOI18N
    jCheckBoxServerSSL.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxServerSSL.toolTipText")); // NOI18N
    jCheckBoxServerSSL.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        jCheckBoxServerSSLStateChanged(evt);
      }
    });

    org.jdesktop.layout.GroupLayout jPanelMailLayout = new org.jdesktop.layout.GroupLayout(jPanelMail);
    jPanelMail.setLayout(jPanelMailLayout);
    jPanelMailLayout.setHorizontalGroup(
      jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanelMailLayout.createSequentialGroup()
        .addContainerGap()
        .add(jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jPanelMailLayout.createSequentialGroup()
            .add(jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(jPanelMailLayout.createSequentialGroup()
                .add(jLabel7)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jTextFieldConfirmTimeout, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
              .add(jPanelMailLayout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jTextFieldReceiverPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 47, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 77, Short.MAX_VALUE)
            .add(jCheckBoxEnableRemoteConnect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 207, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
          .add(jPanelMailLayout.createSequentialGroup()
            .add(jLabel2)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jTextFieldServerHost, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 166, Short.MAX_VALUE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jLabel3)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jTextFieldServerPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 49, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jCheckBoxServerSSL)
            .addContainerGap())))
    );

    jPanelMailLayout.linkSize(new java.awt.Component[] {jLabel1, jLabel2}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

    jPanelMailLayout.setVerticalGroup(
      jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanelMailLayout.createSequentialGroup()
        .addContainerGap()
        .add(jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabel1)
          .add(jTextFieldReceiverPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(jCheckBoxEnableRemoteConnect))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabel2)
          .add(jTextFieldServerHost, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(jCheckBoxServerSSL)
          .add(jTextFieldServerPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(jLabel3))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 25, Short.MAX_VALUE)
        .add(jPanelMailLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabel7)
          .add(jTextFieldConfirmTimeout, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addContainerGap())
    );

    jTabbedPane.addTab(bundle.getString("ApplicationUI.jPanelMail.TabConstraints.tabTitle"), null, jPanelMail, bundle.getString("ApplicationUI.jPanelMail.TabConstraints tabToolTip")); // NOI18N

    jCheckBoxLdap.setText(bundle.getString("ApplicationUI.jCheckBoxLdap.text")); // NOI18N
    jCheckBoxLdap.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxLdap.toolTipText")); // NOI18N
    jCheckBoxLdap.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    jCheckBoxLdap.setMargin(new java.awt.Insets(0, 0, 0, 0));
    jCheckBoxLdap.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        jCheckBoxLdapStateChanged(evt);
      }
    });

    jLabel4.setText(bundle.getString("ApplicationUI.jLabel4.text")); // NOI18N

    jLabel5.setText(bundle.getString("ApplicationUI.jLabel5.text")); // NOI18N

    jLabel6.setText(bundle.getString("ApplicationUI.jLabel6.text")); // NOI18N

    jTextFieldProviderUrl.setText(bundle.getString("ApplicationUI.jTextFieldProviderUrl.text")); // NOI18N
    jTextFieldProviderUrl.setToolTipText(bundle.getString("ApplicationUI.jTextFieldProviderUrl.toolTipText")); // NOI18N
    jTextFieldProviderUrl.setEnabled(false);

    jTextFieldBaseDn.setText(bundle.getString("ApplicationUI.jTextFieldBaseDn.text")); // NOI18N
    jTextFieldBaseDn.setToolTipText(bundle.getString("ApplicationUI.jTextFieldBaseDn.toolTipText")); // NOI18N
    jTextFieldBaseDn.setEnabled(false);

    jTextFieldAttribute.setText(bundle.getString("ApplicationUI.jTextFieldAttribute.text")); // NOI18N
    jTextFieldAttribute.setToolTipText(bundle.getString("ApplicationUI.jTextFieldAttribute.toolTipText")); // NOI18N
    jTextFieldAttribute.setEnabled(false);

    jCheckBoxIsSjis.setText(bundle.getString("ApplicationUI.jCheckBoxIsSjis.text")); // NOI18N
    jCheckBoxIsSjis.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxIsSjis.toolTipText")); // NOI18N
    jCheckBoxIsSjis.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    jCheckBoxIsSjis.setEnabled(false);
    jCheckBoxIsSjis.setMargin(new java.awt.Insets(0, 0, 0, 0));

    org.jdesktop.layout.GroupLayout jPanelLDAPLayout = new org.jdesktop.layout.GroupLayout(jPanelLDAP);
    jPanelLDAP.setLayout(jPanelLDAPLayout);
    jPanelLDAPLayout.setHorizontalGroup(
      jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanelLDAPLayout.createSequentialGroup()
        .add(jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jPanelLDAPLayout.createSequentialGroup()
            .addContainerGap()
            .add(jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel6)
              .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel5)
              .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel4))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(jTextFieldAttribute, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 353, Short.MAX_VALUE)
              .add(jTextFieldBaseDn, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 353, Short.MAX_VALUE)
              .add(jPanelLDAPLayout.createSequentialGroup()
                .add(jTextFieldProviderUrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 261, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jCheckBoxIsSjis))))
          .add(jPanelLDAPLayout.createSequentialGroup()
            .add(12, 12, 12)
            .add(jCheckBoxLdap)))
        .addContainerGap())
    );

    jPanelLDAPLayout.linkSize(new java.awt.Component[] {jLabel4, jLabel5, jLabel6}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

    jPanelLDAPLayout.setVerticalGroup(
      jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanelLDAPLayout.createSequentialGroup()
        .addContainerGap()
        .add(jCheckBoxLdap)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabel4)
          .add(jTextFieldProviderUrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(jCheckBoxIsSjis))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabel5)
          .add(jTextFieldBaseDn, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanelLDAPLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabel6)
          .add(jTextFieldAttribute, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    jTabbedPane.addTab(bundle.getString("ApplicationUI.jPanelLDAP.TabConstraints.tabTitle"), null, jPanelLDAP, bundle.getString("ApplicationUI.jPanelLDAP.TabConstraints tabToolTip")); // NOI18N

    jLabelProgramName.setFont(new java.awt.Font("Dialog", 1, 18));
    jLabelProgramName.setText(bundle.getString("ApplicationUI.jLabelProgramName.text")); // NOI18N

    jLabelProgramVersion.setFont(new java.awt.Font("Dialog", 1, 18));
    jLabelProgramVersion.setText(bundle.getString("ApplicationUI.jLabelProgramVersion.text")); // NOI18N

    jLabelSfURL.setFont(new java.awt.Font("Dialog", 1, 14));
    jLabelSfURL.setText(bundle.getString("ApplicationUI.jLabelSfURL.text")); // NOI18N

    org.jdesktop.layout.GroupLayout jPanelAboutLayout = new org.jdesktop.layout.GroupLayout(jPanelAbout);
    jPanelAbout.setLayout(jPanelAboutLayout);
    jPanelAboutLayout.setHorizontalGroup(
      jPanelAboutLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanelAboutLayout.createSequentialGroup()
        .add(jPanelAboutLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jPanelAboutLayout.createSequentialGroup()
            .addContainerGap()
            .add(jLabelProgramName)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jLabelProgramVersion))
          .add(jPanelAboutLayout.createSequentialGroup()
            .add(55, 55, 55)
            .add(jLabelSfURL)))
        .addContainerGap(38, Short.MAX_VALUE))
    );
    jPanelAboutLayout.setVerticalGroup(
      jPanelAboutLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanelAboutLayout.createSequentialGroup()
        .addContainerGap()
        .add(jPanelAboutLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jLabelProgramName)
          .add(jLabelProgramVersion, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 22, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jLabelSfURL)
        .addContainerGap(57, Short.MAX_VALUE))
    );

    jTabbedPane.addTab(bundle.getString("ApplicationUI.jPanelAbout.TabConstraints.tabTitle"), null, jPanelAbout, bundle.getString("ApplicationUI.jPanelAbout.TabConstraints tabToolTip")); // NOI18N

    jButtonOK.setText(bundle.getString("ApplicationUI.jButtonOK.text")); // NOI18N
    jButtonOK.setToolTipText(bundle.getString("ApplicationUI.jButtonOK.toolTipText")); // NOI18N
    jButtonOK.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonOKActionPerformed(evt);
      }
    });

    jButtonCancel.setText(bundle.getString("ApplicationUI.jButtonCancel.text")); // NOI18N
    jButtonCancel.setToolTipText(bundle.getString("ApplicationUI.jButtonCancel.toolTipText")); // NOI18N
    jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonCancelActionPerformed(evt);
      }
    });

    jButtonQuit.setText(bundle.getString("ApplicationUI.jButtonQuit.text")); // NOI18N
    jButtonQuit.setToolTipText(bundle.getString("ApplicationUI.jButtonQuit.toolTipText")); // NOI18N
    jButtonQuit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonQuitActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createSequentialGroup()
        .addContainerGap()
        .add(jButtonQuit)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 190, Short.MAX_VALUE)
        .add(jButtonOK)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jButtonCancel)
        .addContainerGap())
      .add(jTabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 463, Short.MAX_VALUE)
    );

    layout.linkSize(new java.awt.Component[] {jButtonCancel, jButtonOK, jButtonQuit}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

    layout.setVerticalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
        .add(jTabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jButtonQuit)
          .add(jButtonCancel)
          .add(jButtonOK))
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents
  
  private void formWindowDeiconified(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowDeiconified
    setTitle(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.title"));
    //If enable is can not input field anything in JRE1.4 on Windows.   jButtonOK.requestFocusInWindow();
  }//GEN-LAST:event_formWindowDeiconified
  
  private void formWindowIconified(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowIconified
    setTitle(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.shortTitle"));
  }//GEN-LAST:event_formWindowIconified
  
  private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
    int port;
    try {
      port = Integer.parseInt(jTextFieldReceiverPort.getText());
      checkPortRange(port);
    } catch (NumberFormatException ex) {
      jTextFieldReceiverPort.setBackground(Color.PINK);
      throw ex;
    }
    boolean enableRemoteConnect = jCheckBoxEnableRemoteConnect.isSelected();

    String serverHost = jTextFieldServerHost.getText();
    int serverPort;
    try {
      serverPort = Integer.parseInt(jTextFieldServerPort.getText());
      checkPortRange(serverPort);
    } catch (NumberFormatException ex) {
      jTextFieldServerPort.setBackground(Color.PINK);
      throw ex;
    }
    boolean serverSSL = jCheckBoxServerSSL.isSelected();

    int confirmTimeout;
    try {
      confirmTimeout = Integer.parseInt(jTextFieldConfirmTimeout.getText());
      checkTimeoutRange(confirmTimeout);
    } catch (NumberFormatException nfEx) {
      jTextFieldConfirmTimeout.setBackground(Color.PINK);
      throw nfEx;
    }
        
    boolean enableLdap = jCheckBoxLdap.isSelected();
    String ldapUrl = jTextFieldProviderUrl.getText();
    String rootDn = jTextFieldBaseDn.getText();
    String attribute = jTextFieldAttribute.getText();
    boolean isSjis = jCheckBoxIsSjis.isSelected();
    
    if ( port != ApplicationProperties.getSmtpPort()
    || enableRemoteConnect != ApplicationProperties.getSmtpEnebleRemoteConnect()
    || !serverHost.equals(ApplicationProperties.getSmtpServerHost())
    || serverPort != ApplicationProperties.getSmtpServerPort()
    || serverSSL != ApplicationProperties.getSmtpServerSSL()
    || confirmTimeout != ApplicationProperties.getConfirmTimeout()    
    || enableLdap != ApplicationProperties.getLdap()
    || !ldapUrl.equals(ApplicationProperties.getLdapProviderURL())
    || !rootDn.equals(ApplicationProperties.getLdapRoot())
    || !attribute.equals(ApplicationProperties.getLdapAttributes())
    || isSjis != ApplicationProperties.getLdapIsSjis()
    || isModifiedPotition()
    ) {
      // When modify data, save properries file.
      ApplicationProperties.setSmtpPort(port);
      ApplicationProperties.setSmtpEnableRemoteConnect(enableRemoteConnect);

      ApplicationProperties.setSmtpServerHost(serverHost);
      ApplicationProperties.setSmtpServerPort(serverPort);
      ApplicationProperties.setSmtpServerSSL(serverSSL);

      ApplicationProperties.setConfirmTimeout(confirmTimeout);
      
      ApplicationProperties.setLdap(enableLdap);
      ApplicationProperties.setLdapProviderURL(ldapUrl);
      ApplicationProperties.setLdapRoot(rootDn);
      ApplicationProperties.setLdapAttributes(attribute);
      ApplicationProperties.setLdapIsSjis(isSjis);
      
      smtpClient.configChangeNotify();
      if ( !ApplicationProperties.save() ) {
        new MessageDialogUI(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.error.Fail_the_properties_file_save."), null,
                MessageDialogUI.ERROR_MODE);
      } else {
        iconified();
      }
    } else {
      iconified();
    }
  }//GEN-LAST:event_jButtonOKActionPerformed

  /**
   * Time out second is need to positive number
   */
  private void checkTimeoutRange(final int confirmTimeout) throws NumberFormatException {
    if ( confirmTimeout < 0 ) {
      throw new NumberFormatException(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.exception.Timeout_need_to_a_positive_number"));
    }
  }
  
  /**
   *  Check port number range. It is unsigned short number.
   *  Argument is port number.
   **/
  private void checkPortRange(final int port) {
    if ( port <= 0 || port > 65535 ) {
      throw new NumberFormatException(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.error.Out_of_range."));
    }
  }
  
  private void jButtonQuitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonQuitActionPerformed
    System.exit(0);
  }//GEN-LAST:event_jButtonQuitActionPerformed
  
  private void jCheckBoxLdapStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBoxLdapStateChanged
    boolean check = jCheckBoxLdap.isSelected();
    jTextFieldProviderUrl.setEnabled(check);
    jTextFieldBaseDn.setEnabled(check);
    jTextFieldAttribute.setEnabled(check);
    jCheckBoxIsSjis.setEnabled(check);
  }//GEN-LAST:event_jCheckBoxLdapStateChanged
  
  private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
    //this.setVisible(false);
    resetDisplay();
    if ( portNumberOutOfRangeErrorDialog != null && portNumberOutOfRangeErrorDialog.isVisible() ) {
      portNumberOutOfRangeErrorDialog.dispose();
    }
    iconified();
  }//GEN-LAST:event_jButtonCancelActionPerformed

  private void jCheckBoxServerSSLStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBoxServerSSLStateChanged
    // takuya-o
    boolean check = jCheckBoxServerSSL.isSelected();
    // smtp(port 25) and ssmpt(port 465) switch.   cf. TLS/STARTTLS port 587
    if ( check == true && jTextFieldServerPort.getText().equals("25") ) {
      jTextFieldServerPort.setText("465");
    }else if ( check == false && jTextFieldServerPort.getText().equals("465") ) {
      jTextFieldServerPort.setText("25");
    }
  }//GEN-LAST:event_jCheckBoxServerSSLStateChanged

  private void jTextFieldReceiverPortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldReceiverPortActionPerformed
    // TODO add your handling code here:
  }//GEN-LAST:event_jTextFieldReceiverPortActionPerformed
  
  private boolean isModifiedPotition() {
    int x = 0;
    int y = 0;
    if ( getExtendedState() == JFrame.NORMAL ) {
      Point locationPoint = getLocationOnScreen(); //TODO: IllegalComponentStateException
      x = locationPoint.x;
      y = locationPoint.y;
    } else {
      //Unexpect logic. Because this method call from pushed "OK" button.
      x = getX();
      y = getY();
    }
    int h = this.getHeight();
    int w = this.getWidth();
    boolean modified = false;
    
    if ( x != ApplicationProperties.getConfigDialogPosX()
    || y != ApplicationProperties.getConfigDialogPosY()
    || h != ApplicationProperties.getConfigDialogPosH()
    || w != ApplicationProperties.getConfigDialogPosW()
    ) {
      modified = true;
      ApplicationProperties.setConfigDialogPosX(x);
      ApplicationProperties.setConfigDialogPosY(y);
      ApplicationProperties.setConfigDialogPosH(h);
      ApplicationProperties.setConfigDialogPosW(w);
    }
    return modified;
  }
  
  
  private boolean initSystemTray() {
    useSystemTray = false;
    try {
      Class.forName("java.awt.SystemTray"); // NOI18N
      /* SystemTray suuport */
      final SystemTray tray = SystemTray.getSystemTray();
      if(SystemTray.isSupported()){
        final PopupMenu popup = new PopupMenu();
        final TrayIcon trayIcon = new TrayIcon(loadImageIcon(), 
          java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.shortTitle"),
          popup);
        trayIcon.setImageAutoSize(true);
       
        MenuItem menuItemOpen = new MenuItem(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.title"));
        menuItemOpen.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            deicoified();
          }
        });
        MenuItem menuItemQuit = new MenuItem(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.jButtonQuit.text"));
        menuItemQuit.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            tray.remove(trayIcon);
            dispose();
            System.exit(0);
          }
        });
        popup.add(menuItemOpen);
        popup.add(menuItemQuit);
        tray.add(trayIcon);
       
        this.jButtonQuit.setVisible(false); //unvisible QUIT button.
        useSystemTray = true;
      }
       /**/
    } catch (AWTException ex) {
      System.err.println("SystemTray initialize error.");
      ex.printStackTrace();
    } catch (ClassNotFoundException ex) {
      // Do not support SystemTray on this VM.
    } catch (NoClassDefFoundError ex) {
      // Do not support SystemTray on this VM.
    }
    return useSystemTray;
  }
  
  private void iconified() {
    if ( useSystemTray ) {
      this.setVisible(false);
    } else {
      this.setExtendedState(ICONIFIED);
    }
  }
  
  private void deicoified() {
    if ( useSystemTray ) {
      this.setVisible(true);
    } else {
      this.setExtendedState(NORMAL);
    } 
  }
  
  private Image loadImageIcon() {
    ImageIcon imageIcon = new ImageIcon( getClass()
    .getResource("images/mdc-icon16x16.png") // NOI18N
    ,java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.jLabelProgramName.text"));
    
    return imageIcon.getImage();
  }
  
  /**
   * @param args the command line arguments
   */
  public static void main(String args[]) {
    /* TKYN OLD
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    } catch (Exception e) {
      e.printStackTrace();
    }
     */
    
    //TKYN ORIGNAL BLOCK
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ApplicationUI applicationUI = new ApplicationUI();
        applicationUI.setVisible(true);
        
        applicationUI.useSystemTray = applicationUI.initSystemTray();
        
        //If exsist configuration file, iconise at start up.
        if ( ApplicationProperties.isFileLoaded() ) {
          int x = ApplicationProperties.getConfigDialogPosX();
          int y = ApplicationProperties.getConfigDialogPosY();
          int w = ApplicationProperties.getConfigDialogPosW();
          int h = ApplicationProperties.getConfigDialogPosH();
          
          if ( x > screenSize.width ) {
            x = screenSize.width - w;
            if ( x < 0 ) { x = 0; };
          }
          if ( y > screenSize.height ) {
            y = screenSize.height - h;
            if ( y < 0 ) { y = 0; };
          }
          applicationUI.setBounds(x, y, w, h);
          applicationUI.iconified();
        } else {
          //No Configuration file.
          Dimension frameSize =  ApplicationProperties.getConfigurationDialogSize();
          if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
          }
          if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
          }
          
          applicationUI.setBounds(
                  (screenSize.width - frameSize.width) / 2,
                  (screenSize.height - frameSize.height) / 2,
                  frameSize.width, frameSize.height );
        }
      }
    });
    smtpClient = new SMTPclient();
  }
  private static SMTPclient smtpClient = null;
  private boolean useSystemTray = false;
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton jButtonCancel;
  private javax.swing.JButton jButtonOK;
  private javax.swing.JButton jButtonQuit;
  private javax.swing.JCheckBox jCheckBoxEnableRemoteConnect;
  private javax.swing.JCheckBox jCheckBoxIsSjis;
  private javax.swing.JCheckBox jCheckBoxLdap;
  private javax.swing.JCheckBox jCheckBoxServerSSL;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JLabel jLabel7;
  private javax.swing.JLabel jLabelProgramName;
  private javax.swing.JLabel jLabelProgramVersion;
  private javax.swing.JLabel jLabelSfURL;
  private javax.swing.JPanel jPanelAbout;
  private javax.swing.JPanel jPanelLDAP;
  private javax.swing.JPanel jPanelMail;
  private javax.swing.JTabbedPane jTabbedPane;
  private javax.swing.JTextField jTextFieldAttribute;
  private javax.swing.JTextField jTextFieldBaseDn;
  private javax.swing.JTextField jTextFieldConfirmTimeout;
  private javax.swing.JTextField jTextFieldProviderUrl;
  private javax.swing.JTextField jTextFieldReceiverPort;
  private javax.swing.JTextField jTextFieldServerHost;
  private javax.swing.JTextField jTextFieldServerPort;
  // End of variables declaration//GEN-END:variables
  
}
