/*
 * ToListUITest.java
 * JUnit based test
 *
 * Created on 2007/07/22, 11:41
 */

package org.jent.checksmtp;

import java.util.ArrayList;
import javax.swing.JFrame;
import junit.framework.*;

/**
 *
 * @author tkyn
 */
public class ToListUITest extends TestCase implements ResultNotify {
  private final ArrayList arrayList = new ArrayList();
  private JFrame toListUI = null;
  private boolean result = false;
  
  public ToListUITest(String testName) {
    super(testName);
  }
  
  protected void setUp() throws Exception {
  }
  
  /**
   * Test of main method, of class org.jent.checksmtp.ToListUI.
   *
   * public void testMain() {
   * System.out.println("main");
   *
   * String[] args = null;
   *
   * //ToListUI.main(args);
   *
   * //  review the generated test code and remove the default call to fail.
   * //fail("The test case is a prototype.");
   *
   * }
   */
  
  private void pushTestSetup(String msg) {
    arrayList.add(msg);
    for (int i = 0; i < 100; i++) {
      arrayList.add("NO" + i);
    }
    toListUI = new ToListUI(this, arrayList);
    arrayList.clear();
    
    try {
      synchronized (this) {
        wait(30 * 1000);
        //Wait 30sec
      }
    } catch (InterruptedException e) {
      fail("Dialg wait interrupted");
    }
  }
  
  private synchronized void notifyResult() {
    notify();
  }
  
  public void sayOK() {
    System.out.println("sayOK");
    result = true;
    notifyResult();
  }
  
  public void sayNG() {
    System.out.println("sayNG");
    result = false;
    notifyResult();
  }
  
  public void testPushOK() {
    result = false;
    pushTestSetup("Please push OK button.");
    assertTrue("Time out or push CANCEL", result);
  }
  
  public void testPushCANCEL() {
    result = true;
    pushTestSetup("Please push CANCEL button.");
    assertTrue("Time out or push OK", !result);
  }
  
  public void testPushClose() {
    result = true;
    pushTestSetup("Please close Window.");
    assertTrue("Time out or push OK", !result);
  }
  
  public void testPushCancelAfterTimeOut() {
    ApplicationProperties.setConfirmTimeout(5);
    
    result = true;
    pushTestSetup("Test Confirm Timeout 5sec. Please push CANCEL button.");
    assertTrue("Time out or push OK", !result);
    try {
      System.out.println("Wait 10sec.");
      synchronized(this) {
        wait(10 * 1000);
      }
    } catch (InterruptedException ex) {
      ex.printStackTrace();
      fail("Wait Interrupted.");
    }
    assertTrue("Confirm Timeout Occurred wrong.", !result);
    
  }
  
}
