/*
 * ToListUI.java
 *
 * Created on 2007/07/22, 11:17
 */

package org.jent.checksmtp;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/**
 *
 * @author  tkyn
 */
public class ToListUI extends javax.swing.JFrame {
  private List toList = null;
  private ResultNotify resultNotify = null;
  
  /** Creates new form ToListUI */
  public ToListUI(ResultNotify processer, List toList) {
    super();  //paranoia statement.
    initComponents();
    
    jButtonCancel.requestFocusInWindow();
    //getRootPane().setDefaultButton(jButtonOK);
    
    this.toList = toList;
    this.resultNotify = processer;
    
    if (toList != null) {
      jList1.setListData(toList.toArray());
      //jList1.update();
      jList1.setVisible(true);
    }
    this.setVisible(true);
    toFront(); //from Tiger... setAlwaysOnTop(true);
    
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    //If exsist configuration file, iconise at start up.
    if ( ApplicationProperties.isFileLoaded() ) {
      int x = ApplicationProperties.getConfirmDialogPosX();
      int y = ApplicationProperties.getConfirmDialogPosY();
      int w = ApplicationProperties.getConfirmDialogPosW();
      int h = ApplicationProperties.getConfirmDialogPosH();
      if ( x > screenSize.width ) {
        x = screenSize.width - w;
        if ( x < 0 ) { x = 0; };
      }
      if ( y > screenSize.height ) {
        y = screenSize.height - h;
        if ( y < 0 ) { y = 0; };
      }
      this.setBounds(x, y, w, h);
    } else {
      //No Configuration file.
      Dimension frameSize =  ApplicationProperties.getConfirmDialogSize();
      if (frameSize.height > screenSize.height) {
        frameSize.height = screenSize.height;
      }
      if (frameSize.width > screenSize.width) {
        frameSize.width = screenSize.width;
      }
      this.setBounds(
              (screenSize.width - frameSize.width) / 2,
              (screenSize.height - frameSize.height) / 2,
              frameSize.width, frameSize.height );
    }
    
    //Auto confirm timer
    int timeOut = ApplicationProperties.getConfirmTimeout();
    if ( timeOut > 0 ) {
      confirmTimer.schedule(confirmTimeoutTimerTask, timeOut * 1000L);
    }
  }
  private void cancelConfirmTimeoutTimerTask() {
    if ( !confirmTimeoutTimerTask.cancel() ) {
      System.err.println("Already do task?");
    }
  }
  private static Timer confirmTimer = new Timer();
  private TimerTask confirmTimeoutTimerTask = new TimerTask() {
    public void run() {
      jButtonOKActionPerformed(null);
    }
  };
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc=" Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    jPanel1 = new javax.swing.JPanel();
    jScrollPane1 = new javax.swing.JScrollPane();
    jList1 = new javax.swing.JList();
    jButtonOK = new javax.swing.JButton();
    jButtonCancel = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle"); // NOI18N
    setTitle(bundle.getString("ToListUI.title")); // NOI18N
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    jList1.setModel(new javax.swing.AbstractListModel() {
      String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
      public int getSize() { return strings.length; }
      public Object getElementAt(int i) { return strings[i]; }
    });
    jScrollPane1.setViewportView(jList1);

    jButtonOK.setText(bundle.getString("ToListUI.jButtonOK.text")); // NOI18N
    jButtonOK.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonOKActionPerformed(evt);
      }
    });

    jButtonCancel.setText(bundle.getString("ToListUI.jButtonCancel.text")); // NOI18N
    jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonCancelActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(
      jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanel1Layout.createSequentialGroup()
        .addContainerGap(200, Short.MAX_VALUE)
        .add(jButtonOK)
        .add(14, 14, 14)
        .add(jButtonCancel)
        .addContainerGap())
      .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
    );

    jPanel1Layout.linkSize(new java.awt.Component[] {jButtonCancel, jButtonOK}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

    jPanel1Layout.setVerticalGroup(
      jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 90, Short.MAX_VALUE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jButtonOK)
          .add(jButtonCancel)))
    );

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createSequentialGroup()
        .addContainerGap()
        .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createSequentialGroup()
        .addContainerGap()
        .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addContainerGap())
    );
    pack();
  }// </editor-fold>//GEN-END:initComponents
  
  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    cancelConfirmTimeoutTimerTask();
    restorePosition();
    resultNotify.sayNG();
  }//GEN-LAST:event_formWindowClosing
 
  private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
    cancelConfirmTimeoutTimerTask();
    restorePosition();
    resultNotify.sayNG();
    this.dispose();
  }//GEN-LAST:event_jButtonCancelActionPerformed
  
  private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
    //push OK
    //if ( isVisible() ) {  //Care after dialog closing, confirm time out occurred.  -> use cancelTimerTask.
      restorePosition();
      resultNotify.sayOK();
      this.dispose();
    //}
  }//GEN-LAST:event_jButtonOKActionPerformed
  
  private boolean restorePosition() {
    Point locationPoint;
    if ( isVisible() ) {
      locationPoint = getLocationOnScreen();  //TODO: IllegalComponentStateException
    } else {
      locationPoint = new Point(ApplicationProperties.getConfirmDialogPosX(),
              ApplicationProperties.getConfirmDialogPosY());
    }
    int x = locationPoint.x;
    int y = locationPoint.y;
    int h = this.getHeight();
    int w = this.getWidth();
    boolean modified = false;
    
    if ( x != ApplicationProperties.getConfirmDialogPosX()
    || y != ApplicationProperties.getConfirmDialogPosY()
    || h != ApplicationProperties.getConfirmDialogPosH()
    || w != ApplicationProperties.getConfirmDialogPosW()
    ) {
      modified = true;
      ApplicationProperties.setConfirmDialogPosX(x);
      ApplicationProperties.setConfirmDialogPosY(y);
      ApplicationProperties.setConfirmDialogPosH(h);
      ApplicationProperties.setConfirmDialogPosW(w);
      if ( !ApplicationProperties.save() ) {
        new MessageDialogUI(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ToListUI.error.Fail_the_properties_file_of_dialog_potition_save."),
                null, MessageDialogUI.ERROR_MODE);
      }
    }
    return modified;
  }
  
  /**
   * @param args the command line arguments
   *
   * public static void main(String args[]) {
   * java.awt.EventQueue.invokeLater(new Runnable() {
   * public void run() {
   * new ToListUI().setVisible(true);
   * }
   * });
   * }
   */
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton jButtonCancel;
  private javax.swing.JButton jButtonOK;
  private javax.swing.JList jList1;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JScrollPane jScrollPane1;
  // End of variables declaration//GEN-END:variables
  
}
