package org.jent.checksmtp;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import java.util.Properties;


/**
 * <P>This class hold application properties.</P>
 * <P>"$user.home/.checksmtp.properties" was used to stored data file.</P>
 * <H3>Properties</H3>
 * <DL>
 * <DT> -.port       <DD>Service port number.       (Default:8725)
 * <DT> -.ssl        <DD>Service port use SSL.      (Default:false) //Not use yet.
 * <DT> -.enableRemoteConnect <DD>Permit connect from remote host. (Default:false)
 * <DT> -.serverHost <DD>STMP Server host name.     (Default:mail)
 * <DT> -.serverPort <DD>STMP Server port.          (Default:25)
 * <DT> -.serverSSL <DD>SMTP Server port use SSL.   (Default:false)
 * <DT> -.confirm.timeout <DD> Confirm auto push OK timeput (Default:0 = forever)
 * <DT> -.ladp       <DD>If "true" use LDAP search. (Default:false)
 * <DT> -.ldap.providerUrl <DD>LDAP Provider URL    (Default:ldap://localhost:389
 * <DT> -.ldap.baseDn <DD>LDAP Search root           (Default:C=JP)
 * <DT> -.ldap.isSjis<DD>Addhoc patch: When LDAP Server use SJIS, this propertiy set "true" (Default:false)
 * <DT> -.ldap.attribues<DD>LDAP Search attribues separate by space (Defaut:cn)
 * <DT> -.configDialog.pos.? <DD> Config Dialog position x,y,w,h
 * <DT> -.confirmDialog.pos.? <DD> Confirm Dialog postion x,y,w,h
 * </DL>
 */
public class ApplicationProperties {
  private static final String PREFIX = "org.jent.checksmtp";
  private static final String SMTP_PORT = PREFIX + ".port";
  private static final String SMTP_SSL = PREFIX + ".SSL";
  private static final String SMTP_ENEBLE_REMOTE_CONNECT = PREFIX + ".enableRemoteConnect";
  private static final String SMTP_SERVER_HOST = PREFIX + ".serverHost";
  private static final String SMTP_SERVER_PORT = PREFIX + ".serverPort";
  private static final String SMTP_SERVER_SSL = PREFIX + ".serverSSL";
  private static final String CONFIRM_TIMEOUT = PREFIX + ".confirmTimeout";
  private static final String LDAP_PREFIX = PREFIX + ".ldap";
  private static final String LDAP_PROVIDER_URL = LDAP_PREFIX + ".providerUrl";
  private static final String LDAP_ROOT = LDAP_PREFIX + ".baseDn";
  private static final String LDAP_IS_SJIS = LDAP_PREFIX + ".isSjis";
  private static final String LDAP_IS_ATTRIBUTES = LDAP_PREFIX + ".attributes";
  private static final String CONFIG_DIALOG_PREFIX = PREFIX + ".configDialog";
  private static final String CONFIG_DIALOG_POS_X = CONFIG_DIALOG_PREFIX + ".pos.x";
  private static final String CONFIG_DIALOG_POS_Y = CONFIG_DIALOG_PREFIX + ".pos.y";
  private static final String CONFIG_DIALOG_POS_W = CONFIG_DIALOG_PREFIX + ".pos.w";
  private static final String CONFIG_DIALOG_POS_H = CONFIG_DIALOG_PREFIX + ".pos.h";
  private static final String CONFIRM_DIALOG_PREFIX = PREFIX + ".confirmDialog";
  private static final String CONFIRM_DIALOG_POS_X = CONFIRM_DIALOG_PREFIX + ".pos.x";
  private static final String CONFIRM_DIALOG_POS_Y = CONFIRM_DIALOG_PREFIX + ".pos.y";
  private static final String CONFIRM_DIALOG_POS_W = CONFIRM_DIALOG_PREFIX + ".pos.w";
  private static final String CONFIRM_DIALOG_POS_H = CONFIRM_DIALOG_PREFIX + ".pos.h";
  
  private static final String PROPERTIES_FILENAME = ".checksmtp.properties";
  
  private static Properties applicationProperties = new Properties();
  
  private static String fileName = PROPERTIES_FILENAME;
  
  private static boolean isFileLoaded = false; //Exsist configuration file.
  
  public static boolean isFileLoaded() {
    return isFileLoaded;
  }
  
  static {
    try {
      //InputStream is = ApplicationProperties.class.getClassLoader().getResourceAsStream("checksmtp.properties");
      fileName = System.getProperty("user.home") + File.separator + PROPERTIES_FILENAME;
      FileInputStream is = new FileInputStream(fileName);
      applicationProperties.load(is);
      isFileLoaded = true;
      is.close();
    } catch (IOException e) {
      System.err.println("No checksmtp.properties in " + fileName);
    }
  }
  
  private ApplicationProperties() {
  }
  
  /**
   * Application Properties Save
   */
  public static boolean save() {
    FileOutputStream fos;
    boolean resultOK = true;
    
    try {
      fos = new FileOutputStream(fileName);
      applicationProperties.store(fos, "Appliction Properties");
      fos.close();
    } catch (IOException e) {
      resultOK = false;
      System.err.println(fileName + "was occrred save error.");
      e.printStackTrace();
    }
    return resultOK;
  }
  
  public static String getSmtpServerHost() {
    return applicationProperties.getProperty(SMTP_SERVER_HOST, "mail");
  }
  
  public static void setSmtpServerHost(String obj) {
    applicationProperties.setProperty(SMTP_SERVER_HOST, obj);
  }
  
  public static int getSmtpServerPort() {
    return Integer.parseInt(applicationProperties.getProperty(SMTP_SERVER_PORT, "25"));
  }
 
  public static void setSmtpServerPort(int port) {
    applicationProperties.setProperty(SMTP_SERVER_PORT, new Integer(port).toString());
  }

  public static boolean getSmtpServerSSL() {
    //getProperty(str) default value is null. valueOf(null) retrun FALSE.
    return Boolean.valueOf(applicationProperties.getProperty(SMTP_SERVER_SSL)).booleanValue();
  }
  
  public static void setSmtpServerSSL(boolean ssl) {
    applicationProperties.setProperty(SMTP_SERVER_SSL, Boolean.toString(ssl));
  }
  
  public static int getSmtpPort() {
    return Integer.parseInt(applicationProperties.getProperty(SMTP_PORT, "8725"));
  }
  
  public static void setSmtpPort(int port) {
    applicationProperties.setProperty(SMTP_PORT, new Integer(port).toString());
  }

  public static boolean getSmtpSSL() {
    return Boolean.valueOf(applicationProperties.getProperty(SMTP_SSL)).booleanValue();
  }

  public static void setSmtpSSL(boolean ssl) {
    applicationProperties.setProperty(SMTP_SSL, Boolean.toString(ssl));
  }

  public static boolean getSmtpEnebleRemoteConnect() {
    String str = applicationProperties.getProperty(SMTP_ENEBLE_REMOTE_CONNECT);
    return Boolean.valueOf(str).booleanValue();
  }
  
  public static void setSmtpEnableRemoteConnect(boolean obj) {
    applicationProperties.setProperty(SMTP_ENEBLE_REMOTE_CONNECT, Boolean.toString(obj));
  }
  
  public static String getLdapProviderURL() {
    return applicationProperties.getProperty(LDAP_PROVIDER_URL, "ldap://localhost:389");
  }
  
  public static void setLdapProviderURL(String obj) {
    applicationProperties.setProperty(LDAP_PROVIDER_URL, obj);
  }
  
  public static String getLdapRoot() {
    return applicationProperties.getProperty(LDAP_ROOT, "C=JP");
  }
  
  public static void setLdapRoot(String obj) {
    applicationProperties.setProperty(LDAP_ROOT, obj);
  }
  
  public static boolean getLdapIsSjis() {
    return Boolean.valueOf(applicationProperties.getProperty(LDAP_IS_SJIS)).booleanValue();
  }
  
  public static void setLdapIsSjis(boolean obj) {
    applicationProperties.setProperty(LDAP_IS_SJIS, Boolean.toString(obj));
  }
  
  public static boolean getLdap() {
    String str = applicationProperties.getProperty(LDAP_PREFIX);
    //the value true if the string is ignoring case "true".
    Boolean flg = Boolean.valueOf(str);
    return flg.booleanValue();
  }
  
  public static void setLdap(boolean obj) {
    applicationProperties.setProperty(LDAP_PREFIX, Boolean.toString(obj));
  }
  
  public static String getLdapAttributes() {
    return applicationProperties.getProperty(LDAP_IS_ATTRIBUTES, "cn");
  }
  
  public static void setLdapAttributes(String obj) {
    applicationProperties.setProperty(LDAP_IS_ATTRIBUTES, obj);
  }
  
  //
  // Config Dialog
  //
  public static Dimension getConfigurationDialogSize() {
    Dimension resultDimension = new Dimension(getConfigDialogPosW(), getConfigDialogPosH());
    return resultDimension;
  }
  public static int getConfigDialogPosX() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_X, "0"));
  }
  
  public static void setConfigDialogPosX(int x) {
    applicationProperties.setProperty(CONFIG_DIALOG_POS_X, new Integer(x).toString());
  }
  
  public static int getConfigDialogPosY() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_Y, "0"));
  }
  
  public static void setConfigDialogPosY(int y) {
    applicationProperties.setProperty(CONFIG_DIALOG_POS_Y, new Integer(y).toString());
  }
  
  public static int getConfigDialogPosW() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_W, "400"));
  }
  
  public static void setConfigDialogPosW(int w) {
    applicationProperties.setProperty(CONFIG_DIALOG_POS_W, new Integer(w).toString());
  }
  
  public static int getConfigDialogPosH() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_H, "232"));
  }
  
  public static void setConfigDialogPosH(int h) {
    applicationProperties.setProperty(CONFIG_DIALOG_POS_H, new Integer(h).toString());
  }
  
  //
  // Confirm Dialog
  //
  static Dimension getConfirmDialogSize() {
    Dimension resultDimension = new Dimension(getConfirmDialogPosW(), getConfirmDialogPosH());
    return resultDimension;
  }
  
  public static int getConfirmDialogPosX() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_X, "0"));
  }
  
  public static void setConfirmDialogPosX(int x) {
    applicationProperties.setProperty(CONFIRM_DIALOG_POS_X, new Integer(x).toString());
  }
  
  public static int getConfirmDialogPosY() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_Y, "0"));
  }
  
  public static void setConfirmDialogPosY(int y) {
    applicationProperties.setProperty(CONFIRM_DIALOG_POS_Y, new Integer(y).toString());
  }
  
  public static int getConfirmDialogPosW() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_W, "400"));
  }
  
  public static void setConfirmDialogPosW(int w) {
    applicationProperties.setProperty(CONFIRM_DIALOG_POS_W, new Integer(w).toString());
  }
  
  public static int getConfirmDialogPosH() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_H, "177"));
  }
  
  public static void setConfirmDialogPosH(int h) {
    applicationProperties.setProperty(CONFIRM_DIALOG_POS_H, new Integer(h).toString());
  }
  
  //CONFIRM_TIMEOUT
    public static int getConfirmTimeout() {
    return Integer.parseInt(applicationProperties.getProperty(CONFIRM_TIMEOUT, "0"));
  }
  
  public static void setConfirmTimeout(int sec) {
    applicationProperties.setProperty(CONFIRM_TIMEOUT, new Integer(sec).toString());
  }
}
