#ifndef QSHELL_HPP
#define QSHELL_HPP
/*
 * QShell.hpp
 * ru - utf8
 *
 *  Created on: 3 dec 2019 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * ------------------------------------------------------------------------
 *  Qt AppShell in QThread container. It makes shell, destroying with thread.
 *
 *  Usage:
 *  ...
    main_shell = QShell::newShell(&shellio, "app");
    a.connect( main_shell, &QShell::finished, &a, &QApplication::closeAllWindows );
    a.connect( &a, &QApplication::lastWindowClosed
               , &main_shell->shell_service(), &QShellService::terminate_all );
    tests_cli.registerCmd();

    main_shell->start();
    ...
 *
 */


#include <QObject>
#include <QThread>

#include <project-shell.hpp>


//этот класс нужен для расшаривания общих сигналов на все консоли
//как минимум сигнал общего останова и закрытия.
class QShellService : public QObject{
    Q_OBJECT
public:
    QShellService():QObject(){}
    ~QShellService(){
        
    }

public slots:
    void terminate_all() {
        emit request_terminate_all();
    }
signals:
    void request_terminate_all(void);
};



class QShell : public QObject
{
    Q_OBJECT
public:
    typedef AppShell        shell_t;
    typedef StdIO_Device    io_t;

    // этот шелл нельзя создавать статическим. Нитка всегда дестроит свой шелл по завершении.
    template <typename... Args>
    static
    QShell* newShell(Args ... args ) {
        return new QShell(args...);
    }
    virtual ~QShell();

    QThread* thread() {return _thread;}
    shell_t& shell() {return _shell;}

    // @return true - if shell is ok and run
    bool start();

    // берет obj во владение shell(), он будет удален вместе с завершением shell()
    void take_own(QObject&& obj);

public slots:
    
    void process(void);
    void terminate(void){  shell().terminate(); }

signals:
    void finished(void);

protected:
    // этот шелл нельзя создавать статическим. Нитка всегда дестроит свой шелл по завершении.
    QShell(QObject *parent = nullptr);
    QShell(StdIO_Device *device
                    , shell_t::const_cmd shell_name = shell_t::default_shell_name
                    , QObject *parent = nullptr
            );

    shell_t     _shell;
    QThread*    _thread;
    void init_thread();

public:
    // API общее на все консоли.
    // через shell_service() ведем общее управление всеми консолями.
    static 
    QShellService&    shell_service(){
        static QShellService single_service;
        return single_service;
    }

};

namespace cli {
    QStringList QStringList(const ILinesHystory& src);
};// namespace cli

#endif // SHELL_HPP
