/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#ifndef HAL_STM32F4_MCU_RCC_H_
#define HAL_STM32F4_MCU_RCC_H_

#include <mcu-chip.h>
// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if defined(STM32F4)   //__STM32F4xx_HAL_CONF_H
#include <stm32f4xx_ll_bus.h>
#include <stm32f4xx_ll_rcc.h>
#else
#warning "uncknown STM32 HAL"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define APBCLK_BIT(port)  ((((uint32_t)port)-(APB1PERIPH_BASE) )>>10)

#define APB1CLK_BIT(port) (((uint32_t)port-APB1PERIPH_BASE)>>10)
#define APB2CLK_BIT(port) (((uint32_t)port-APB2PERIPH_BASE)>>10)
#define AHB1CLK_BIT(port) (((uint32_t)port-AHB1PERIPH_BASE)>>10)


#define APBCLK_BIT(port)  ((((uint32_t)port)-(APB1PERIPH_BASE) )>>10)
// APB bit clocks:
//  0.... 63 - APB1
//  64 ...   - PAB2
enum {
      APB2CLK       = APBCLK_BIT(APB2PERIPH_BASE)
    , APB2CLK_Pos   = APB2CLK
};

#define IS_APB1CLK(port)  ( APBCLK_BIT(port) < 32 )
#define IS_APB2CLK(port)  ( APBCLK_BIT(port) >= APB2CLK )

#define APB1CLK_BIT(port) (((uint32_t)port-APB1PERIPH_BASE)>>10)
#define APB2CLK_BIT(port) (((uint32_t)port-APB2PERIPH_BASE)>>10)
#define AHB1CLK_BIT(port) (((uint32_t)port-AHB1PERIPH_BASE)>>10)

#define RCC_GPIO(port)  (1ull<< AHB1CLK_BIT(port))
#define RCC_TIMER(port) (1ull<< APBCLK_BIT(port))



#define RCC_APB1_EnableClock(x)  LL_APB1_GRP1_EnableClock(x)
#define RCC_APB2_EnableClock(x)  LL_APB2_GRP1_EnableClock(x)

#define RCC_APB1_DisableClock(x) LL_APB1_GRP1_DisableClock(x)
#define RCC_APB2_DisableClock(x) LL_APB2_GRP1_DisableClock(x)

inline
void RCC_EnableClock_APB( void* port ){
    unsigned idx = APBCLK_BIT(port);
    if (idx < APB2CLK)
        RCC_APB1_EnableClock( 1ul << idx );
    else
        RCC_APB2_EnableClock( 1ul<< (idx - APB2CLK_Pos) );
}

inline
void RCC_DisableClock_APB( void* port ){
    unsigned idx = APBCLK_BIT(port);
    if (idx < APB2CLK)
        RCC_APB1_DisableClock( 1ul << idx );
    else
        RCC_APB2_DisableClock( 1ul<< (idx - APB2CLK_Pos) );
}

#define RCC_EnableClock_GPIO(port)      LL_AHB1_GRP1_EnableClock(  RCC_GPIO(port) )
#define RCC_DisableClock_GPIO(port)     LL_AHB1_GRP1_DisableClock( RCC_GPIO(port) )
#define RCC_EnableClock_SPI(port)       RCC_EnableClock_APB( port )
#define RCC_DisableClock_SPI(port)      RCC_DisableClock_APB( port )
#define RCC_EnableClock_UART(port)      RCC_EnableClock_APB( port )
#define RCC_DisableClock_UART(port)     RCC_DisableClock_APB( port )



typedef LL_RCC_ClocksTypeDef        RCC_ClocksTypeDef;
#define RCC_GetSystemClocksFreq(x)  LL_RCC_GetSystemClocksFreq(x)



#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
