/*
 * flash_hal.hpp
 *
 *  Created on: 15/01/2019
  *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 */
#ifndef HAL_FLASH_SPI_x25_HPP_
#define HAL_FLASH_SPI_x25_HPP_

#include <flash_hal.hpp>
#include <ssp_hal.hpp>
#include "x25_flash.h"



class FLASH_SPI_x25
        : public SPIFlash_WritableDevice
{
public:
    typedef SPIFlash_WritableDevice inherited;

    FLASH_SPI_x25(dev_name);

    virtual DevResult init();
    virtual DevResult deinit();

    // bound - начальная подготовка флеши к работе, сверка ID, и параметров
    virtual DevResult bind();
    virtual id_str id() {return ID_W25Q64.raw;};

public:
    // идентификатор чипа windond
    union ID_t{
        enum {idLEN = 3};
        struct __PACKED {
            u8      vendor_id;
            u16     chip_id;
        };
        u8          raw[idLEN];
    };
    enum{
          idWINBOND     = 0xEF
        , idW25Q64_SPI  = 0x1740    //spi mode
        , idW25Q64_QPI  = 0x1760    //qpi mode
        , id64M_CAPACITY= 0x16
    };
    static const ID_t   ID_W25Q64;
    enum {
          PAGE_SIZE = W25Q64_PAGE_SIZE
        , SEC_SIZE  = W25Q64_SEC_SIZE
        , SEC_PAGES = SEC_SIZE/PAGE_SIZE
        , SECTORS   = W25Q64_SECTORS
        , SIZE      = SECTORS*SEC_SIZE
    };
protected:
    static const Describe   info_W25Q64;
    enum {SSP_MODE_W25Q64 = ssp_t::msCLKHI | ssp_t::msCLKRISE
                    | ssp_t::msNB8 | ssp_t::msCS_KEEP
    };
};

typedef FLASH_SPI_x25   FLASH_SPI_W25Q64;



#endif //HAL_FLASH_SPI_x25_HPP_

