/*
 * flash_hal.hpp
 *
 *  Created on: 26 нояб. 2018 г.
  *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 */
#ifndef HAL_FLASH_1636RR52_HPP_
#define HAL_FLASH_1636RR52_HPP_

#include <flash_hal.hpp>
#include <ssp_hal.hpp>


class FLASH_1636RR52
        : public SPIFlash_WritableDevice
{
public:
    typedef SPIFlash_WritableDevice inherited;

    FLASH_1636RR52(dev_name);

    virtual int init();
    virtual int deinit();

    // bound - начальная подготовка флеши к работе, сверка ID, и параметров
    virtual DevResult bind();
    virtual id_str id() {return ID_1636RR52.raw;};

    // версия чтения миландра использует CMD_FAST_READ с 4byte адресом
    virtual DevResult read(unsigned page, void* dst, unsigned len);

    virtual PTResult protect_sectors(unsigned page, unsigned len, bool onoff);
    DevResult protect_sector(unsigned page, bool onoff);

public:
    enum {
          CMD_SEC_PROTECT   = 0x36
        , CMD_SEC_UNPROTECT = 0x39
        , CMD_SEC_PROTECT_STATE = 0x3C
    };
    enum ProtectStausID{
         psPROTECTED = 0xff
         , psUNPROTECTED = 0
    };
    // поля регистра статуса
    enum {
          // SectorWriteProtected
          SR_SWP_NO   = 0
        , SR_SWP_ALL  = 0xC
        , SR_SWP_SOME = 0x8
        , SR_SWP_Msk  = 0xC
        // RESET Enabled
        , SR_RSTE     = 0x40
        // SectorProtectionRegisterLock
        , SR_SPRL     = 0x80
    };
    static
    bool is_protected(unsigned status){
        return (status & SR_SWP_Msk) != SR_SWP_NO;
    }
public:
    // идентификатор Миландра
    union ID_t{
        enum {idLEN = 2};
        u8          raw[idLEN];
        struct {
            u8      vendor_id;
            u8      chip_id;
        };
    };
    enum{
          idMILANDR     = 0x1
        , id1636RR52    = 0xC8
    };
    static const ID_t   ID_1636RR52;
protected:
    static const Describe   info_1636RR52;

    DevResult protect_sec(void* dst, addr_t page, unsigned len);
    DevResult unprotect_sec(void* dst, addr_t page, unsigned len);
};


#endif //HAL_FLASH_1636RR52_HPP_

