/*
    (C) 2017 Renesas Electronics Corporation.
     This software is released under the terms and conditions described in LICENSE_RENESAS.TXT included in the project.
*/
/**
  * @file    rl78g14.h
  * @author  Renesas Electronics Corporation
  * @brief   Sample microcontroller driver program header.
**/

#if !defined(__RP_RL78G14_H__)
#define __RP_RL78G14_H__
#define __RP_RL78G14_H__


#include "r_iomap.h"
#include "rl78g14_init.h"
#include "rl78g14_gpio.h"
#include "rl78g14_spi.h"
#include "rl78g14_delay.h"
#include "rl78g14_general.h"
#include "rl78g14_rtc.h"
#include "rl78g14_uart.h"

/*! 
 * MCU operating modes definitions.
 */
enum RpMcuOperatingMode
{
   RP_MCU_MODE_RUN = 0x00U,
   RP_MCU_MODE_HALT,
   RP_MCU_MODE_SNOOZE,
   RP_MCU_MODE_STOP
};
 
/*! 
 * Global variable RpMcuLowPowerMode, indicating if MCU is set to low power mode.
 */
extern uint8_t RpMcuLowPowerMode;

/*! 
 * I/O port SFR configurations definitions
 */
#define GPIO_MODE_INPUT             (1U)
#define GPIO_MODE_OUTPUT            (0U)
#define GPIO_MODE_AF_OD             (1U)
#define GPIO_MODE_AF_PP             (0U)
#define GPIO_MODE_OUTPUT_OD         (1U)
#define GPIO_MODE_OUTPUT_PP         (0U)

/*! 
 * IAWCTL SFR configurations definitions
 */
#define RP_RL78SFR_IAWCTL_GPORT     (0x01U)
#define RP_RL78SFR_IAWCTL_GINT      (0x02U)
#define RP_RL78SFR_IAWCTL_GCSC      (0x04U)
#define RP_RL78SFR_IAWCTL_GRAM0     (0x10U)
#define RP_RL78SFR_IAWCTL_GRAM1     (0x20U)
#define RP_RL78SFR_IAWCTL_IAWEN     (0x80U)

#define RP_SFR_PROTECT_PORT         RP_RL78SFR_IAWCTL_GPORT
#define RP_SFR_PROTECT_INT          RP_RL78SFR_IAWCTL_GINT
#define RP_SFR_PROTECT_CSC          RP_RL78SFR_IAWCTL_GCSC

#define RP_RAM_PROTECT_0BYTE        ~( RP_RL78SFR_IAWCTL_GRAM1 |  RP_RL78SFR_IAWCTL_GRAM0)
#define RP_RAM_PROTECT_128BYTE       (~RP_RL78SFR_IAWCTL_GRAM1 |  RP_RL78SFR_IAWCTL_GRAM0)
#define RP_RAM_PROTECT_256BYTE       ( RP_RL78SFR_IAWCTL_GRAM1 | ~RP_RL78SFR_IAWCTL_GRAM0)
#define RP_RAM_PROTECT_512BYTE       ( RP_RL78SFR_IAWCTL_GRAM1 |  RP_RL78SFR_IAWCTL_GRAM0)

#define RP_ILLEGAL_MEM_ACCESS_ENABLE    RP_RL78SFR_IAWCTL_IAWEN
#define RP_ILLEGAL_MEM_ACCESS_DISABLE  ~RP_RL78SFR_IAWCTL_IAWEN

#if defined(__CCRL__)
/*! 
 * MCU-RF interfaces definitions
 */
#define RP_RFCHIP_DIO1_PORT         P7_bit.no7
#define RP_RFCHIP_DIO0_PORT         P7_bit.no6
#define RP_CSI_CS_PORT              P7_bit.no5
#define RP_NREST_PORT               P7_bit.no3
#define RP_RFCHIP_DIO1_PM           PM7_bit.no7
#define RP_RFCHIP_DIO0_PM           PM7_bit.no6
#define RP_CSI_CS_PM                PM7_bit.no5
#define RP_NREST_PM                 PM7_bit.no3
#elif defined(__ICCRL78__)
/*! 
 * MCU-RF interfaces definitions
 */
#define RP_RFCHIP_DIO1_PORT         P7_bit.no7
#define RP_RFCHIP_DIO0_PORT         P7_bit.no6
#define RP_CSI_CS_PORT              P7_bit.no5
#define RP_NREST_PORT               P7_bit.no3
#define RP_RFCHIP_DIO1_PM           PM7_bit.no7
#define RP_RFCHIP_DIO0_PM           PM7_bit.no6
#define RP_CSI_CS_PM                PM7_bit.no5
#define RP_NREST_PM                 PM7_bit.no3
#endif //#if defined(__CCRL__)

/*! 
 * SFR type
 */
typedef volatile __near unsigned char  * RP_SFR_CHAR;
typedef volatile __near unsigned short * RP_SFR_SHORT;

#endif // #if !defined(__RP_RL78G14_H__)
