/*
 * mcu_crc.h
 *
 *  Created on: 27/04/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * ------------------------------------------------------------------------------------
 *  RA CRC-core support
 */

#ifndef BSP_CPU_MCU_CRC_H_
#define BSP_CPU_MCU_CRC_H_

#include <mcu-chip.h>

enum CRCPolyID{
    CRCPOLY_CRC8        = 1, CRCPOLY_17     = CRCPOLY_CRC8,
    CRCPOLY_CRC16       = 2, CRCPOLY_8005   = CRCPOLY_CRC16,
    CRCPOLY_CRC16CCITT  = 3, CRCPOLY_1021   = CRCPOLY_CRC16CCITT,
    CRCPOLY_CRC32       = 4, CRCPOLY_04C11DB7   = CRCPOLY_CRC32,
    CRCPOLY_CRC32C      = 5, CRCPOLY_1EDC6F41   = CRCPOLY_CRC32C,
};

enum CRCOrderID {
    CRC_LSB = 0,
    CRC_MSB = R_CRC_CRCCR0_LMS_Msk,
};


void CRC_enable(void);
void CRC_disable(void);


INLINE
void CRC_clear_accu(void){
    R_CRC->CRCCR0_b.DORCLR = 1;
}

INLINE
void CRC_add8( uint8_t x){
    R_CRC->CRCDIR_BY = x;
}

INLINE
void CRC_add32( uint32_t x){
    R_CRC->CRCDIR = x;
}

INLINE
uint8_t CRC_value8( void ){
    return R_CRC->CRCDOR_BY;
}

INLINE
uint16_t CRC_value16( void ){
    return R_CRC->CRCDOR_HA;
}

INLINE
uint32_t CRC_value32( void ){
    return R_CRC->CRCDOR;
}



#endif /* BSP_CPU_MCU_CRC_H_ */
