/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#ifndef HAL_MCU_DMA_H_
#define HAL_MCU_DMA_H_

#include <stdint.h>

// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if 1 //defined(STM32F4)   //__STM32F4xx_HAL_CONF_H
#include <stm32f4xx_ll_dma.h>
#include <stm32f4xx_ll_tim.h>
#else
#warning "uncknown STM32 HAL"
#endif

#include <c_compat.h>

#ifdef STM32F446xx

// \return - dma stream index
#define DMA_STREAM_OF( stream ) __LL_DMA_GET_STREAM( stream )
INLINE
int     dma_stream_of(DMA_Stream_TypeDef* x){
    unsigned base = (uintptr_t)x;
    if (base < DMA2_BASE)
        base -= DMA1_Stream0_BASE;
    else
        base -= DMA2_Stream0_BASE;
    return (base >> 3)/3;
}


#define DMA1_CHANNEL_TIM3    LL_DMA_CHANNEL_5
#define DMA1_STREAM_TIM3TRIG LL_DMA_STREAM_4
#define DMA1_STREAM_TIM3CH1  LL_DMA_STREAM_4
#define DMA1_STREAM_TIM3CH2  LL_DMA_STREAM_5
#define DMA1_STREAM_TIM3CH3  LL_DMA_STREAM_7
#define DMA1_STREAM_TIM3CH4  LL_DMA_STREAM_2

#define DMA1_CHANNEL_TIM5    LL_DMA_CHANNEL_6
#define DMA1_STREAM_TIM5CH1  LL_DMA_STREAM_2
#define DMA1_STREAM_TIM5CH2  LL_DMA_STREAM_4
#define DMA1_STREAM_TIM5CH3  LL_DMA_STREAM_0
#define DMA1_STREAM_TIM5CH4  LL_DMA_STREAM_1
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct DMA_BIND_TIM{
    DMA_TypeDef*       dma;
    TIM_TypeDef*       tim;
    uint8_t            tim_ch;
    uint8_t            dma_ch;
    uint8_t            stream;
};


#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
