/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 *--------------------------------------------------------------------
 * do not use it directly. it should include via <chip_rcc.h>
 */

#ifndef HAL_STM32H7_MCU_RCC_H_
#define HAL_STM32H7_MCU_RCC_H_

// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if defined(STM32H7)   //__STM32F4xx_HAL_CONF_H
#else
#warning "uncknown STM32 HAL"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define APBCLK_BIT(port)  ((((uint32_t)port)-(APB1PERIPH_BASE) )>>10)

#define APB1CLK_BIT(port) (((uint32_t)port-APB1PERIPH_BASE)>>10)
#define APB2CLK_BIT(port) (((uint32_t)port-APB2PERIPH_BASE)>>10)
#define AHB4CLK_BIT(port) (((uint32_t)port-D3_AHB1PERIPH_BASE)>>10)

// APB bit clocks:
//  0.... 63 - APB1
//  64 ...   - PAB2
enum {
      APB2CLK       = APBCLK_BIT(APB2PERIPH_BASE)
    , APB2CLK_Pos   = APB2CLK
};

#define IS_APB1CLK(port)  ( APBCLK_BIT(port) < 32 )
#define IS_APB2CLK(port)  ( APBCLK_BIT(port) >= APB2CLK )

#define RCC_GPIO(port)  (1ull<< AHB4CLK_BIT(port))
#define RCC_TIMER(port) (1ull<< APBCLK_BIT(port))
#define RCC_UART(port)  (1ull<< APBCLK_BIT(port))



inline
void RCC_APB1_EnableClock(unsigned long long x){
    if ((long)(x) != 0)
        SET_BIT(RCC->APB1LENR, (long)(x) );
    if ((long)(x>>32) != 0)
        SET_BIT(RCC->APB1HENR, (long)(x>>32));
    /* Delay after an RCC peripheral clock enabling */
    __IO uint32_t tmpreg;
    tmpreg = RCC->APB1LENR;
    UNUSED(tmpreg);
    tmpreg = RCC->APB1HENR;
    UNUSED(tmpreg);
}

inline
void RCC_APB1_DisableClock(uint64_t x){
    if ((long)(x) != 0)
        CLEAR_BIT(RCC->APB1LENR, (long)(x) );
    if ((long)(x>>32) != 0)
        CLEAR_BIT(RCC->APB1HENR, (long)(x>>32));
    /* Delay after an RCC peripheral clock enabling */
    __IO uint32_t tmpreg;
    tmpreg = RCC->APB1LENR;
    UNUSED(tmpreg);
    tmpreg = RCC->APB1HENR;
    UNUSED(tmpreg);
}

inline
void RCC_APB2_EnableClock(unsigned long x)  {
    SET_BIT(RCC->APB2ENR, x );
    __IO uint32_t tmpreg;
    tmpreg = RCC->APB2ENR;
    UNUSED(tmpreg);
}

inline
void RCC_APB2_DisableClock(unsigned long x)  {
    CLEAR_BIT(RCC->APB2ENR, x );
    __IO uint32_t tmpreg;
    tmpreg = RCC->APB2ENR;
    UNUSED(tmpreg);
}

inline
void RCC_AHB4_EnableClock(unsigned long x)  {
    SET_BIT(RCC->AHB4ENR, x );
    __IO uint32_t tmpreg;
    tmpreg = RCC->AHB4ENR;
    UNUSED(tmpreg);
}

inline
void RCC_AHB4_DisableClock(unsigned long x)  {
    CLEAR_BIT(RCC->AHB4ENR, x );
    __IO uint32_t tmpreg;
    tmpreg = RCC->AHB4ENR;
    UNUSED(tmpreg);
}



inline
void RCC_EnableClock_APB( void* port ){
    unsigned idx = APBCLK_BIT(port);
    if (idx < APB2CLK)
        RCC_APB1_EnableClock( 1ull << idx );
    else
        RCC_APB2_EnableClock( 1ul<< (idx - APB2CLK_Pos) );
}

inline
void RCC_DisableClock_APB( void* port ){
    unsigned idx = APBCLK_BIT(port);
    if (idx < APB2CLK)
        RCC_APB1_DisableClock( 1ull << idx );
    else
        RCC_APB2_DisableClock( 1ul<< (idx - APB2CLK_Pos) );
}

#define RCC_EnableClock_GPIO(port)      RCC_AHB4_EnableClock(  RCC_GPIO(port) )
#define RCC_DisableClock_GPIO(port)     RCC_AHB4_DisableClock( RCC_GPIO(port) )
#define RCC_EnableClock_SPI(port)       RCC_EnableClock_APB( port )
#define RCC_DisableClock_SPI(port)      RCC_DisableClock_APB( port )
#define RCC_EnableClock_UART(port)      RCC_EnableClock_APB( port )
#define RCC_DisableClock_UART(port)     RCC_DisableClock_APB( port )



//typedef RCC_ClkInitTypeDef          RCC_ClocksTypeDef;
typedef struct
{
  uint32_t SYSCLK_Frequency;        /*!< SYSCLK clock frequency */
  uint32_t HCLK_Frequency;          /*!< HCLK clock frequency */
  uint32_t PCLK1_Frequency;         /*!< PCLK1 clock frequency */
  uint32_t PCLK2_Frequency;         /*!< PCLK2 clock frequency */
  uint32_t PCLK3_Frequency;         /*!< PCLK2 clock frequency */
  uint32_t PCLK4_Frequency;         /*!< PCLK2 clock frequency */
} RCC_ClocksTypeDef;

void RCC_GetSystemClocksFreq(RCC_ClocksTypeDef* x);

#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
