/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
*      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_MDR32F9QX_MCU_GPIO_H_
#define HAL_MDR32F9QX_MCU_GPIO_H_

#include <c_compat.h>
#include <stdint.h>
#include <project-conf.h>
#include <MDR32F9Qx_port.h>

#define GPIO_PORT_NO(port)  (((uint32_t)port-MDR_PORTA_BASE)>>15)
//#define RCC_GPIO(port)  ( RST_CLK_PER_CLOCK_PCLK_EN_PORTA<<GPIO_PORT_NO(port) )

#ifdef __cplusplus
extern "C" {
#endif


typedef MDR_PORT_TypeDef        GPIO_TypeDef;
typedef PORT_InitTypeDef        GPIO_InitTypeDef;
#define GPIO_StructInit(...)    PORT_StructInit(__VA_ARGS__)
#define GPIO_Init(...)          PORT_Init(__VA_ARGS__)

#define GPIO_SetBits(...)       PORT_SetBits(__VA_ARGS__)
#define GPIO_ResetBits(...)     PORT_ResetBits(__VA_ARGS__)
#define GPIO_WriteBit(...)      PORT_WriteBit(__VA_ARGS__)
#define GPIO_ReadInputData(...) PORT_ReadInputData(__VA_ARGS__)

#define GPIOA_BASE              MDR_PORTA_BASE
#define GPIOA                   MDR_PORTA
#define GPIOB                   MDR_PORTB
#define GPIOC                   MDR_PORTC
#define GPIOD                   MDR_PORTD
#define GPIOE                   MDR_PORTE
#define GPIOF                   MDR_PORTF

INLINE
unsigned GPIO_Bits(GPIO_TypeDef* port, unsigned pins){
    return port->RXTX & pins;
}


// описатель стиля пина, для упрощенного объявления структуры инициализации пина PIN_INIT
enum PinStyle{
      psPU  = 1 //pull up
    , psPD  = 2 //pull dn
    , psINV = 4 //inverted
    , psOD  = 8 //open drain
    , psNONE = 0
};

struct PIN_INIT_s{
    GPIO_TypeDef*   port;
    uint8_t         pin;
    uint8_t         style;
};
typedef struct PIN_INIT_s PIN_INIT;
#define PININIT_DEF(p, n, _style) {\
        struct_field(port) p, struct_field(pin) n, struct_field(style) _style\
    }

// описатель структуры инициализации группы пинов на альтернативную функцию
struct GPIOFUNC_INIT{
    GPIO_TypeDef*       port;
    uint16_t            pins;
    PORT_FUNC_TypeDef   func;
};
typedef struct GPIOFUNC_INIT GPIOFUNC_INIT;
#define PINFUNC_DEF(p, n, f) {\
        struct_field(port) p, struct_field(pins) n, struct_field(func) f\
    }



extern const GPIOFUNC_INIT UART1A_GPIO;
extern const GPIOFUNC_INIT UART1B_GPIO;
extern const GPIOFUNC_INIT UART1D_GPIO;
extern const GPIOFUNC_INIT UART1E_GPIO;

extern const GPIOFUNC_INIT UART2F_GPIO;
extern const GPIOFUNC_INIT UART2D_GPIO;



#ifdef FIX_JTAG_A

#define JTAGA_PINS  0x1fu
#define FIX_JTAGA_PINS(port, pins) ( (port != GPIOB)? (pins) : (pins & ~JTAGB_PINS) )

INLINE
uint32_t fix_jtaga_pins(GPIO_TypeDef* port, unsigned pin){
    const uint32_t jtagpins = JTAGA_PINS;
    if (port != GPIOB)
        return pin;
    else
        return pin & ~jtagpins;
}

#else
#define fix_jtaga_pins(port, pins)  pins
#define FIX_JTAGA_PINS(port, pins)  pins
#endif
#ifdef FIX_JTAG_B

#define JTAGB_PINS  0x1fu
#define FIX_JTAGB_PINS(port, pins) ( (port != GPIOD)? (pins) : (pins & ~JTAGB_PINS) )

INLINE
uint32_t fix_jtagb_pins(GPIO_TypeDef* port, unsigned pin){
    const uint32_t jtagpins = 0x1f;
    if (port != GPIOD)
        return pin;
    else
        return pin & ~jtagpins;
}

#else
#define fix_jtagb_pins(port, pins)  pins
#define FIX_JTAGB_PINS(port, pins)  pins
#endif

#define FIX_JTAG_PINS(port, pins) FIX_JTAGB_PINS(port, (FIX_JTAGA_PINS(port, pins)) )
/*
INLINE
uint32_t FIX_JTAG_PINS(GPIO_TypeDef* port, unsigned pin){
    return FIX_JTAGA_PINS(port, FIX_JTAGB_PINS(port, pin));
}
*/
uint32_t fix_jtag_pins(GPIO_TypeDef* port, unsigned pin);

#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
