/*
 * print_hal.cpp
 *
 *  Created on: 15 ���. 2019 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#include "print_hal.hpp"


//********************         Std_Print      ****************************
//virtual
int StdPrint::printf(const char* fmt, ...){
  va_list arp;
  va_start(arp, fmt);
  int res = vprintf(fmt, ~0, arp);
  va_end(arp);
  return res;
}


int StdPrint::vprintf(const char* fmt, va_list args){
    return vprintf(fmt, ~0, args);
}

#include <stdio.h>
int StdOutPrint::vprintf(const char* fmt, unsigned nargs, va_list args){
    return ::vprintf(fmt, args);
}

int StdOutPrint::puts(const char* s){
    return ::puts(s);
}

//********************         StdOUT_Print      ****************************
StdOUT_BufferPrint::StdOUT_BufferPrint()
{
  print_out = NULL;
  print_buf = NULL;
  print_limit   = 0;
  buffer_shared = false;
};

StdOUT_BufferPrint::StdOUT_BufferPrint(StdOUT_BufferPrint::device_t* useio)
{
  print_out = useio;
  print_buf = NULL;
  print_limit   = 0;
  buffer_shared = false;
};

void StdOUT_BufferPrint::init(StdOUT_BufferPrint::device_t* useio
    , char* buf, unsigned len)
{
  print_out = useio;
  print_buf = buf;
  if (buf != NULL)
    print_limit = len;
  else
    print_limit = 0;
}

//virtual
int StdOUT_BufferPrint::printf(const char* fmt, ...){
  if (print_out == NULL)
    return 0;
  if (print_limit <= 0)
    return 0;
  va_list arp;
  va_start(arp, fmt);
  int res = vprintf(fmt, ~0, arp);
  va_end(arp);
  return res;
}

//virtual
int StdOUT_BufferPrint::vprintf(const char* fmt, unsigned nargs, va_list args){
  if (print_out == NULL)
    return 0;
  if (print_limit <= 0)
    return 0;
  //* shared buffer need lock before fill
  if (buffer_shared)
    if (!print_out->put_access(true))
      return 0;
  int len = vsnprintf(print_buf, print_limit, fmt, args);
  //* for non-shared buffer need only locked puts
  int res = io()->putData(print_buf, len);
  if (buffer_shared)
    print_out->put_access(false);
  return res;
}

//virtual
int StdOUT_BufferPrint::puts(const char* s){
    if (print_out == NULL)
      return 0;
    int res = io()->puts(s);
    return res;
}


StdOUT_ProxyPrint::StdOUT_ProxyPrint(StdOUT_ProxyPrint::device_t* useio)
:print_out(useio)
{}

//virtual
int StdOUT_ProxyPrint::printf(const char* fmt, ...){
  if (print_out == NULL)
    return 0;
  va_list arp;
  va_start(arp, fmt);
  int res = io()->vprintf(fmt, ~0, arp);
  va_end(arp);
  return res;
}

//virtual
int StdOUT_ProxyPrint::vprintf(const char* fmt, unsigned nargs, va_list args){
  if (print_out != NULL)
    return io()->vprintf(fmt, nargs, args);
  else
    return 0;
}

//virtual
int StdOUT_ProxyPrint::puts(const char* s){
    if (print_out != NULL)
      return io()->puts(s);
    else
      return 0;
}



