// HyperLinkCtrl.h cnCp[NR|[lg
#ifndef __WXC_HYPERLINKCTRL__
#define __WXC_HYPERLINKCTRL__

#include "wxc.h"
#include "../StaticCtrl.h"


// {F
#define RGB_BLACK     RGB(  0,   0,   0)  // 
#define RGB_RED       RGB(255,   0,   0)  // 
#define RGB_GREEN     RGB(  0, 255,   0)  // 
#define RGB_BLUE      RGB(  0,   0, 255)  // 
#define RGB_YELLOW    RGB(255, 255,   0)  // 
#define RGB_MAGENTA   RGB(255,   0, 255)  // }[^
#define RGB_CYAN      RGB(  0, 255, 255)  // VA
#define RGB_WHITE     RGB(255, 255, 255)  // 
#define RGB_ORANGE    RGB(255, 128,   0)  // IW


_WXC_BEGIN                              // namespace wxc {

class HyperLinkCtrl : public wgc::StaticCtrl
{
public:
	HyperLinkCtrl(
		HCURSOR hCursor = NULL,
		LPCTSTR lpszURL = NULL,
		const COLORREF colorNormal = RGB_BLUE,
		const COLORREF colorPoint  = RGB_ORANGE,
		const COLORREF colorActive = RGB_RED);

	~HyperLinkCtrl(void);

	BOOL SetURL(LPCTSTR lpszURL = NULL);
	void SetFontStyle(const BOOL bUnderline = TRUE, const BOOL bItalic = FALSE);
	void SetCursor(HCURSOR hCursor);

protected:
	BOOL OnSetCursor(HWND hWnd, const UINT nHitTest, const UINT message);
	void OnCaptureChanged(HWND hWnd);

	void OnSetFocus(HWND hWndLoseFocus);
	void OnKillFocus(HWND hWndLoseFocus);

	UINT OnNcHitTest(const POINT &point);

	void OnMouseLeave(void);
	void OnMouseMove  (const UINT nFlags, const POINT &point);
	void OnLButtonDown(const UINT nFlags, const POINT &point);
	void OnLButtonUp  (const UINT nFlags, const POINT &point);

	void OnPaint(void);

private:
	typedef enum tagLINKSTATE
	{
		LS_NORMAL,
		LS_HOVER,
		LS_CLICKING,
		LS_DRAGGING,
	} LINKSTATE;

	// NF
	COLORREF m_colorNormal;                 // ʏ̃NF
	COLORREF m_colorPoint;                  // |Cg
	COLORREF m_colorActive;                 // NbN

	// \[X
	HCURSOR m_hCursor;
	HFONT   m_hFont;

	// tH[JX``H
	BOOL m_bDrawFocusRect;

	// URL֘A
	wgc::tstring_t m_url;
	void JumpToURL(void) const;

	// NԊ֘A
	LINKSTATE m_status;
	void SetStatus(const LINKSTATE status);

	COLORREF GetLinkColor(void) const;

	// OLEhbOhbv֘A
	DWORD OleDragDrop(void) const;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(HyperLinkCtrl)
};

_WXC_END                                // }

#endif // __WXC_HYPERLINKCTRL__
